<?php
/** @var $customizer XT_Framework_Customizer */

if ( $this->core->access_manager()->can_use_premium_code__premium_only() ) {

	$fields[] = array(
		'id'          => 'hidden_on_pages',
		'section'     => 'visibility',
		'label'       => esc_html__( 'Hide cart on these pages', 'woo-floating-cart' ),
		'description' => esc_html__( 'Note: The cart is automatically disabled on WooCommerce native cart / checkout pages', 'woo-floating-cart' ),
		'type'        => 'select',
		'multiple'    => 999,
		'choices'     => XT_Framework_Customizer_Options::get_page_options(),
		'priority'    => 10,
		'default'     => ''
	);

	$fields[] = array(
		'id'       => 'visible_on_empty',
		'section'  => 'visibility',
		'label'    => esc_html__( 'Keep visible on empty', 'woo-floating-cart' ),
		'type'     => 'toggle',
		'default'  => '0',
		'priority' => 10
	);

	$fields[] = array(
		'id'       => 'visibility',
		'section'  => 'visibility',
		'label'    => esc_html__( 'Device Visibility', 'woo-floating-cart' ),
		'type'     => 'radio',
		'choices'  => array(
			'show-on-mobile-only'    => esc_attr__( 'Show on mobile only', 'woo-floating-cart' ),
			'show-on-tablet-mobile'  => esc_attr__( 'Show on tablet and mobile', 'woo-floating-cart' ),
			'show-on-tablet-desktop' => esc_attr__( 'Show on tablet and desktop', 'woo-floating-cart' ),
			'show-on-desktop-only'   => esc_attr__( 'Show on desktop only', 'woo-floating-cart' ),
			'show-on-all'            => esc_attr__( 'Show on all', 'woo-floating-cart' ),
		),
		'default'  => 'show-on-all',
		'priority' => 10
	);

} else {

	$fields[] = array(
		'id'      => 'visibility_features',
		'section' => 'visibility',
		'type'    => 'xt-premium',
		'default' => array(
			'type'  => 'image',
			'value' => $this->core->plugin_url() . 'admin/customizer/assets/images/visibility.png',
			'link'  => $this->core->plugin_upgrade_url()
		)
	);
}