<?php
if (empty($duration)) {
    $duration = $gallery_configs['theme']['slider_theme']['duration'];
}

if (empty($animation)) {
    $animation = $gallery_configs['theme']['slider_theme']['animation'];
}

if (empty($auto_animation)) {
    $auto_animation = $gallery_configs['theme']['slider_theme']['auto_animation'];
}

$class[] = 'flexslider gallery_addon_flexslider carousel wpmfflexslider';
$class[] = 'wpmf-has-border-radius-' . $img_border_radius;
$class[] = 'wpmf-gutterwidth-' . $gutterwidth;
if ((int)$columns === 1) {
    $class[] = 'wpmf-gg-one-columns';
} else {
    $class[] = 'wpmf-gg-multiple-columns';
}

$class = implode(' ', $class);
$shadow = 0;
$style = '';
if ($img_shadow !== '') {
    if ((int) $columns > 1) {
        $style .= '#' . $selector . ' .wpmf-gallery-item:hover {box-shadow: ' . $img_shadow . ' !important; transition: all 200ms ease;}';
        $shadow = 1;
    }
}

if ((int) $gutterwidth === 0) {
    $shadow = 0;
}
if ($border_style !== 'none') {
    if ((int) $columns === 1) {
        $style .= '#' . $selector . ' .wpmf-gallery-item img:not(.glrsocial_image) {border: ' . $border_color . ' '. $border_width .'px '. $border_style .';}';
    } else {
        $style .= '#' . $selector . ' .wpmf-gallery-item .wpmf-gallery-icon {border: ' . $border_color . ' '. $border_width .'px '. $border_style .';}';
    }
} else {
    $border_width = 0;
}

wp_add_inline_style('wpmf-gallery-style', $style);
echo '<div class="wpmf-gallerys wpmf-gallerys-addon">';
echo '<div id="' . esc_attr($selector) . '" data-id="' . esc_attr($selector) . '" class="' . esc_attr($class) . '" data-gutterwidth="' . esc_attr($gutterwidth) . '" data-border-width="' . esc_attr($border_width) . '" data-wpmfcolumns="' . esc_attr($columns) . '"
 data-duration="' . esc_attr($duration) . '" data-animation="' . esc_attr($animation) . '" data-auto_animation="' . esc_attr($auto_animation) . '">';
echo '<ul class="slides wpmf-slides">';
$i = 0;
$current_theme = get_option('current_theme');
if (isset($current_theme) && $current_theme === 'Gleam') {
    $tclass = 'fancybox';
} else {
    $tclass = '';
}

foreach ($attachments as $img_id => $attachment) {
    $image_meta = wp_get_attachment_metadata($img_id);
    if (empty($image_meta['height']) || empty($image_meta['width'])) {
        continue;
    }
    $img = wp_get_attachment_image_src($img_id, $size);
    if (!$img) {
        continue;
    }
    if (!empty($caption_lightbox)) {
        $post_title = esc_html($attachment->post_excerpt);
    } else {
        $post_title = esc_html($attachment->post_title);
    }
    $post_excerpt = esc_html($attachment->post_excerpt);
    $img_tags = get_post_meta($attachment->ID, 'wpmf_img_tags', true);
    $sizes = image_get_intermediate_size($attachment->ID, $size);
    if (!$sizes) {
        $sizes = wp_get_attachment_metadata($attachment->ID);
    }

    $link_target = get_post_meta($attachment->ID, '_gallery_link_target', true);
    list($src, $width, $height) = $img;
    $alt = trim(strip_tags(get_post_meta($img_id, '_wp_attachment_image_alt', true))); // Use Alt field first
    $tg = get_post_meta($attachment->ID, '_gallery_link_target', true);
    $icon = "<span class='hover_img'></span>";

    if ((int)$columns === 1) {
        $icon = '<span class="hover_img ' . $tclass . '"></span>';
    }

    $iOutput = $icon . '<img src="' . $src . '" alt="' . $alt . '" />';
    $image_output = '';
    if (!empty($link)) {
        if ($customlink) {
            $url = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            if ($url === '') {
                $url = get_attachment_link($img_id);
            }
            $image_output = '<a class="' . $tclass . '"
             href="' . $url . '" target="' . $link_target . '">' . $iOutput . '</a>';
        } elseif ('post' === $link) {
            $url = get_attachment_link($img_id);
            $image_output = '<a class="' . $tclass . '"
             href="' . $url . '" target="' . $link_target . '">' . $iOutput . '</a>';
        } elseif ('file' === $link) {
            if (get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
                $lightbox = 0;
                $url = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
                $data_size = '';
            } else {
                $lightbox = 1;
                $item_urls = wp_get_attachment_image_src($img_id, $targetsize);
                $url = $item_urls[0];
                $data_size = $item_urls[1] . 'x' . $item_urls[2];
            }

            $remote_video = get_post_meta($img_id, 'wpmf_remote_video_link', true);
            if (!empty($remote_video)) {
                $image_output = '<a data-size="' . $data_size . '"
                 class="' . $tclass . ' isvideo wpmfgalleryaddonswipe" data-swipe="' . $lightbox . '"
                  href="' . $remote_video . '" target="' . $link_target . '"
                   title="' . $post_title . '">' . $iOutput . '</a>';
            } else {
                $image_output = '<a data-size="' . $data_size . '"
                 class="' . $tclass . ' not_video wpmfgalleryaddonswipe" data-swipe="' . $lightbox . '"
                  href="' . $url . '" target="' . $link_target . '"
                   title="' . $post_title . '">' . $iOutput . '</a>';
            }
        } else {
            if (get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
                $lightbox = 0;
                $url = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
                $image_output = '<a class="' . $tclass . '" href="' . $url . '"
                 target="' . $link_target . '" title="' . $post_title . '">' . $iOutput . '</a>';
            } else {
                $image_output = '<img src="' . $src . '" width="' . $width . '" height="' . $height . '" alt="' . $alt . '" />';
            }
        }
    }

    $orientation = ($image_meta['height'] > $image_meta['width']) ? 'portrait' : 'landscape';
    echo '<li class="wpmf-gallery-item item" data-tags="' . esc_html($img_tags) . '">';
    echo '<div class="wpmf-gallery-icon ' . esc_html($orientation) . '">';
    echo $image_output; // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
    echo '</div>';
    if (trim($post_excerpt) || trim($post_title)) {
        echo '<div class="wpmf-front-box top">';
        echo '<a>';
        echo '<span class="title">' . esc_html($post_title) . '</span>';
        echo '<span class="caption">' . esc_html($post_excerpt) . '</span>';
        echo '</a>';
        echo '</div>';
    }

    echo $social; // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
    echo '</li>';
}


echo '</ul>';
echo '</div></div>';
