<?php
$class[] = 'gallery-masonry gallery-portfolio';
$class[] = 'galleryid-' . $id;
$class[] = 'gallery-columns-' . $columns;
$class[] = 'gallery-size-' . $size_class;
$class[] = 'wpmf-has-border-radius-' . $img_border_radius;
$class[] = 'wpmf-gutterwidth-' . $gutterwidth;
$class[] = 'wpmf-gallery-bottomspace-default';
$class[] = 'wpmf-gallery-clear';
$class = implode(' ', $class);

$padding_masonry = get_option('wpmf_padding_portfolio');
if (!isset($padding_masonry) && $padding_masonry === '') {
    $padding_masonry = 10;
}
$gutterwidth = isset($gutterwidth) ? $gutterwidth : $padding_masonry;
$current_theme = get_option('current_theme');
if (isset($current_theme) && $current_theme === 'Gleam') {
    $tclass = 'fancybox';
} else {
    $tclass = '';
}

$lists = array();
$lists_full = array();
if ((isset($gallery_configs['progressive_loading']) && (int)$gallery_configs['progressive_loading'] === 0) || !empty($notlazyload)) {
    $lazy_load = false;
} else {
    $lazy_load = true;
}

$j = 0;

foreach ($attachments as $img_id => $attachment) {
    $image_meta = wp_get_attachment_metadata($img_id);
    if (empty($image_meta['height']) || empty($image_meta['width'])) {
        continue;
    }

    if (!empty($caption_lightbox)) {
        $item_title = esc_html($attachment->post_excerpt);
    } else {
        $item_title = esc_html($attachment->post_title);
    }
    $post_excerpt = esc_html($attachment->post_excerpt);
    $link_target = get_post_meta($attachment->ID, '_gallery_link_target', true);
    $img_tags = get_post_meta($attachment->ID, 'wpmf_img_tags', true);
    $icon = '';

    if ($customlink) {
        $image_output = $this->galleryGetAttachmentLink($img_id, $size, false, $targetsize, $customlink, $link_target);
        $url = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
        if ($url === '') {
            $url = get_attachment_link($img_id);
        }
        $icon = '<a href="' . $url . '" title="' . $item_title . '" class="hover_img ' . $tclass . '" target="' . $link_target . '"></a>';
        $icon .= '<a class="portfolio_lightbox ' . $tclass . '" href="' . $url . '" title="' . $item_title . '" target="' . $link_target . '">+</a>';
        $icon .= $social;
    } elseif (!empty($link) && 'file' === $link) {
        $remote_video = get_post_meta($img_id, 'wpmf_remote_video_link', true);
        $image_output = $this->galleryGetAttachmentLink($img_id, $size, false, $targetsize, $customlink, $link_target);
        if (strpos($image_output, "data-swipe='0'") || strpos($image_output, 'data-swipe="0"')) {
            $url = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            $icon = '<a data-swipe="0" href="' . $url . '" title="' . $item_title . '" class="hover_img ' . $tclass . '" target="' . $link_target . '"></a>';
            $icon .= '<a data-swipe="0" class="portfolio_lightbox ' . $tclass . '" href="' . $url . '" title="' . $item_title . '" target="' . $link_target . '">+</a>';
            $icon .= $social;
        } else {
            $item_urls = wp_get_attachment_image_src($img_id, $targetsize);
            $url = $item_urls[0];
            $data_size = $item_urls[1] . 'x' . $item_urls[2];
            if (!empty($remote_video)) {
                $icon = '<a data-size="' . $data_size . '" data-swipe="1" href="' . $remote_video . '"
 title="' . $item_title . '" class="wpmfgalleryaddonswipe hover_img ' . $tclass . ' isvideo"></a>';
                $icon .= '<a data-swipe="1" class="wpmfgalleryaddonswipe portfolio_lightbox ' . $tclass . ' isvideo"
 href="' . $remote_video . '" title="' . $item_title . '">+</a>';
                $icon .= $social;
            } else {
                $icon = '<a data-size="' . $data_size . '" data-swipe="1" href="' . $url . '" title="' . $item_title . '"
 class="wpmfgalleryaddonswipe hover_img ' . $tclass . ' not_video"></a>';
                $icon .= '<a data-swipe=1 class="wpmf-plug-icon wpmfgalleryaddonswipe portfolio_lightbox ' . $tclass . ' not_video"
 href="' . $url . '" title="' . $item_title . '">+</a>';
                $icon .= $social;
            }
        }
    } elseif (!empty($link) && 'none' === $link) {
        if (get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
            $image_output = $this->galleryGetAttachmentLink($img_id, $size, false, $targetsize, $customlink, $link_target);
            $url = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            $icon = '<a href="' . $url . '" title="' . $item_title . '" class="hover_img ' . $tclass . '" target="' . $link_target . '"></a>';
            $icon .= '<a class="portfolio_lightbox ' . $tclass . '" href="' . $url . '" title="' . $item_title . '" target="' . $link_target . '">+</a>';
            $icon .= $social;
        } else {
            $image_output = wp_get_attachment_image($img_id, $size, false, array('data-type' => 'wpmfgalleryimg'));
            $icon = '<span class="hover_img"></span><span class="portfolio_lightbox" title="' . $item_title . '">+</span>';
            $icon .= $social;
        }
    } else {
        $image_output = $this->galleryGetAttachmentLink($img_id, $size, true, 'large', false, $link_target);
    }

    $orientation = ($image_meta['height'] > $image_meta['width']) ? 'portrait' : 'landscape';
    $item = '<div class="wpmf-gallery-item" data-tags="' . $img_tags . '">';
    $item .= '<div class="wpmf-gallery-icon ' . $orientation . '">' . $icon . ' ' . $image_output . '</div>';
    if (trim($post_excerpt) || trim($item_title)) {
        $item .= "<div class='wpmf-caption-text wpmf-gallery-caption'>";
        $item .= "<span class='title'>" . wptexturize($item_title) . ' </span><br>';
        $item .= "<span class='excerpt'>" . wptexturize($post_excerpt) . '</span>';
        $item .= '</div>';
    }
    $item .= '</div>';

    if (!$lazy_load) {
        $lists[] = $item;
    } else {
        if ($j >= 4) {
            $lists[] = $item;
        }
        $j++;
    }
    $lists_full[] = $item;
}

$json_lists = esc_html(json_encode($lists));
$style = '';
if ($img_shadow !== '') {
    $style .= '#' . $selector . ' .wpmf-gallery-item img:not(.glrsocial_image):hover, #' . $selector . ' .wpmf-gallery-item .hover_img {box-shadow: ' . $img_shadow . ' !important; transition: all 200ms ease;}';
}

if ($border_style !== 'none') {
    $style .= '#' . $selector . ' .wpmf-gallery-item img:not(.glrsocial_image) {border: ' . $border_color . ' '. $border_width .'px '. $border_style .'}';
}

wp_add_inline_style('wpmf-gallery-style', $style);

echo '<div class="wpmf-gallerys wpmf-gallerys-addon" data-id="' . esc_html($id) . '">';
echo '<div id="' . esc_html($selector) . '" data-item="' . esc_html($json_lists) . '" class="' . esc_html($class) . '" data-gutter-width="' . esc_html($gutterwidth) . '"
  data-wpmfcolumns="' . esc_html($columns) . '">';
foreach ($lists_full as $i => $list) {
    if (!$lazy_load) {
        echo $list; // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
    } else {
        if ($i < 4) {
            echo $list; // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
        }
    }
}

echo "</div></div>\n";
