<?php
$lists = array();
$lists_full = array();
if ((isset($gallery_configs['progressive_loading']) && (int)$gallery_configs['progressive_loading'] === 0) || !empty($notlazyload)) {
    $lazy_load = false;
} else {
    $lazy_load = true;
}

$j = 0;

foreach ($attachments as $img_id => $attachment) {
    $image_meta = wp_get_attachment_metadata($img_id);
    if (empty($image_meta['height']) || empty($image_meta['width'])) {
        continue;
    }
    $orientation = '';

    if (!empty($caption_lightbox)) {
        $post_title = esc_html($attachment->post_excerpt);
    } else {
        $post_title = esc_html($attachment->post_title);
    }

    $post_title = esc_html($attachment->post_title);
    $post_excerpt = esc_html($attachment->post_excerpt);
    $caption_text = trim($post_excerpt);
    $link_target = get_post_meta($attachment->ID, '_gallery_link_target', true);
    $img_tags = get_post_meta($attachment->ID, 'wpmf_img_tags', true);

    if ($customlink) {
        $image_output = $this->galleryGetAttachmentLink($img_id, $size, false, $targetsize, $customlink, $link_target);
        $url = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
        if ($url === '') {
            $url = get_attachment_link($img_id);
        }
        $icon = '<a href="' . $url . '" title="' . $post_title . '" class="hover_img" target="' . $link_target . '"></a>';
        $icon .= $social;
    } elseif (!empty($link) && 'file' === $link) {
        $remote_video = get_post_meta($img_id, 'wpmf_remote_video_link', true);
        $image_output = $this->galleryGetAttachmentLink($img_id, $size, false, $targetsize, $customlink, $link_target);
        if (strpos($image_output, "data-swipe='0'") || strpos($image_output, 'data-swipe="0"')) {
            $url = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            $icon = '<a data-swipe="0" href="' . $url . '" title="' . $post_title . '" class="hover_img" target="' . $link_target . '"></a>';
            $icon .= $social;
        } else {
            $item_urls = wp_get_attachment_image_src($img_id, $targetsize);
            $url = $item_urls[0];
            $data_size = $item_urls[1] . 'x' . $item_urls[2];
            if (!empty($remote_video)) {
                $icon = '<a data-size="' . $data_size . '" data-swipe="1" href="' . $remote_video . '"
 title="' . $post_title . '" class="wpmfgalleryaddonswipe wpmf_gallery_lightbox hover_img isvideo"></a>';
                $icon .= $social;
            } else {
                $icon = '<a data-size="' . $data_size . '" data-swipe="1" href="' . $url . '" title="' . $post_title . '"
 class="wpmfgalleryaddonswipe wpmf_gallery_lightbox hover_img not_video"></a>';
                $icon .= $social;
            }
        }
    } elseif (!empty($link) && 'none' === $link) {
        if (get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
            $image_output = $this->galleryGetAttachmentLink($img_id, $size, false, $targetsize, $customlink, $link_target);
            $url = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            $icon = '<a href="' . $url . '" title="' . $post_title . '" class="hover_img" target="' . $link_target . '"></a>';
            $icon .= $social;
        } else {
            $image_output = wp_get_attachment_image($img_id, $size, false, array('data-type' => 'wpmfgalleryimg'));
            $icon = '<span class="hover_img"></span>';
            $icon .= $social;
        }
    } else {
        $image_output = $this->galleryGetAttachmentLink($img_id, $size, true, 'large', false, $link_target);
    }

    $orientation = ($image_meta['height'] > $image_meta['width']) ? 'portrait' : 'landscape';
    $item = '<figure class="wpmf-gallery-item gallery-item">';
    $item .= '<div class="wpmf-gallery-icon ' . $orientation . '">' . $icon . ' ' . $image_output . '</div>';
    if ($caption_text !== '') {
        $item .= '<h4 class="wpmf-card-title text-center wpmf-gallery-caption">' . wptexturize($caption_text) . '</h4>';
    } else {
        $item .= '<h4 class="wpmf-card-title text-center wpmf-gallery-caption">' . wptexturize($attachment->post_title) . '</h4>';
    }
    $item .= '</figure>';

    if (!$lazy_load) {
        $lists[] = $item;
    } else {
        if ($j >= 4) {
            $lists[] = $item;
            // add line break
            if (($j + 1) % $columns === 0) {
                $lists[] = '<hr class="wpmfglr-line-break" />';
            }
        }
        $j++;
    }
    $lists_full[] = $item;
}

$class[] = 'row wpmf_gallery_default gallery_default glrdefault';
$class[] = 'galleryid-' . $id;
$class[] = 'gallery-columns-' . $columns;
$class[] = 'gallery-size-' . $size_class;
$class[] = 'wpmf-has-border-radius-' . $img_border_radius;
$class[] = 'wpmf-gutterwidth-' . $gutterwidth;
$class = implode(' ', $class);
$json_lists = esc_html(json_encode($lists));

$style = '';
if ($img_shadow !== '') {
    $style .= '#' . $selector . ' .wpmf-gallery-item img:not(.glrsocial_image):hover, #' . $selector . ' .wpmf-gallery-item .hover_img {box-shadow: ' . $img_shadow . ' !important; transition: all 200ms ease;}';
}

if ($border_style !== 'none') {
    $style .= '#' . $selector . ' .wpmf-gallery-item img:not(.glrsocial_image) {border: ' . $border_color . ' ' . $border_width . 'px ' . $border_style . '}';
}
wp_add_inline_style('wpmf-gallery-style', $style);
echo '<div class="wpmf-gallerys wpmf-gallerys-addon" id="' . esc_attr($selector) . '" data-id="' . esc_attr($id) . '">';
echo '<div data-id="' . esc_attr($id) . '" data-item="' . esc_attr($json_lists) . '" data-wpmfcolumns="' . esc_attr($columns) . '" class="' . esc_attr($class) . '">';

foreach ($lists_full as $i => $list) {
    if (!$lazy_load) {
        // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
        echo $list;
    } else {
        if ($i < 4) {
            // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
            echo $list;
        }
    }
}

echo '</div></div>';
