<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');

/**
 * Class WpmfGlrAddonFrontEnd
 * This class that holds most of the front-end functionality for WP Media Folder Gallery
 */
class WpmfGlrAddonFrontEnd
{
    /**
     * WpmfGlrAddonFrontEnd constructor.
     */
    public function __construct()
    {
        if (is_plugin_active('wp-media-folder/wp-media-folder.php')) {
            add_shortcode('wpmfgallery', array($this, 'galleryShortcode'));
            add_action('wp_ajax_nopriv_wpmf_load_gallery', array($this, 'loadGallery'));
            add_action('wp_ajax_wpmf_load_gallery', array($this, 'loadGallery'));
            add_action('wp_ajax_get_galleries', array($this, 'getGalleries'));
            add_action('wp_ajax_nopriv_get_galleries', array($this, 'getGalleries'));
            add_action('wp_ajax_nopriv_getParentsCats', array($this, 'getParentsCats'));
            add_action('wp_ajax_getParentsCats', array($this, 'getParentsCats'));
        }
    }

    /**
     * Get term to display folder tree
     *
     * @return void
     */
    public function getGalleries()
    {
        $dirs = array();
        $id   = 0;
        // phpcs:ignore WordPress.Security.NonceVerification.Missing -- get gallery on frontend
        if (!empty($_POST['id'])) {
            // phpcs:ignore WordPress.Security.NonceVerification.Missing -- get gallery on frontend
            $id = (int) $_POST['id'];
        }

        // Retrieve the terms in a given taxonomy or list of taxonomies.
        $categorys = get_categories(
            array(
                'taxonomy'   => WPMF_GALLERY_ADDON_TAXO,
                'orderby'    => 'name',
                'order'      => 'ASC',
                'parent'     => $id,
                'hide_empty' => false
            )
        );

        foreach ($categorys as $category) {
            $child      = get_term_children((int) $category->term_id, WPMF_GALLERY_ADDON_TAXO);
            $countchild = count($child);
            $dirs[]     = array(
                'type'        => 'dir',
                'file'        => $category->name,
                'id'          => $category->term_id,
                'parent_id'   => $category->parent,
                'count_child' => $countchild,
                'term_group'  => $category->term_group
            );
        }

        if (count($dirs) === 0) {
            wp_send_json(array('status' => false));
        } else {
            wp_send_json(array('status' => true, 'dirs' => $dirs));
        }
    }

    /**
     * Loop get parent list gallery
     *
     * @param integer $id     Id of current gallery
     * @param array   $result Result
     *
     * @return array
     */
    public function loopGetParentsCats($id, $result)
    {
        $term = get_term($id, WPMF_GALLERY_ADDON_TAXO);
        if ((int) $term->parent !== 0) {
            $result = $this->loopGetParentsCats($term->parent, $result);
        }
        $result[] = $term->term_id;
        return $result;
    }

    /**
     * Get parents categories
     *
     * @return void
     */
    public function getParentsCats()
    {
        if (empty($_POST['wpmf_gallery_nonce'])
            || !wp_verify_nonce($_POST['wpmf_gallery_nonce'], 'wpmf_gallery_nonce')) {
            die();
        }

        $result = array();
        if (isset($_POST['id'])) {
            $id       = (int) $_POST['id'];
            $term     = get_term($id, WPMF_GALLERY_ADDON_TAXO);
            $result   = $this->loopGetParentsCats($term->parent, $result);
            $result[] = $id;
        }
        wp_send_json($result);
    }

    /**
     * Get social html
     *
     * @return string
     */
    public function getSocialHtml()
    {
        $social_sharing      = wpmfGetOption('social_sharing');
        $social_sharing_link = wpmfGetOption('social_sharing_link');

        foreach ($social_sharing_link as $attr_key => $attr_value) {
            ${$attr_key} = $attr_value;
        }

        $social       = '';
        if ((int) $social_sharing === 1) {
            if (!empty($facebook) || !empty($twitter) || !empty($instagram) || !empty($pinterest)) {
                $social .= '<div class="wpmfglr_social">';
                if (!empty($facebook)) {
                    $social .= '<a href="' . $facebook . '"  target="_blank">
<span class="dashicons dashicons-facebook-alt"></span></a>';
                }

                if (!empty($twitter)) {
                    $social .= '<a href="' . $twitter . '"  target="_blank">
<span class="dashicons dashicons-twitter"></span></a>';
                }

                if (!empty($instagram)) {
                    $social .= '<a href="' . $instagram . '"  target="_blank">
<span class="dashicons dashicons-instagram"></span></a>';
                }

                if (!empty($pinterest)) {
                    $social .= '<a href="' . $pinterest . '"  target="_blank">
<img class="glrsocial_image" src="' . WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/images/pinterest.png" /></a>';
                }

                $social .= '</div>';
            }
        }

        return $social;
    }

    /**
     * Run shortcode gallery
     *
     * @param array $attr Params of gallery
     *
     * @return string
     */
    public function galleryShortcode($attr)
    {
        wp_enqueue_style(
            'wpmf-material-icon',
            'https://fonts.googleapis.com/css?family=Material+Icons|Material+Icons+Outlined'
        );

        wp_enqueue_style(
            'wpmf-material-design-iconic-font.min',
            WPMF_PLUGIN_URL . '/assets/css/material-design-iconic-font.min.css',
            array(),
            WPMF_VERSION
        );
        /* Get all params */
        $post   = get_post();
        static $instance = 0;
        $instance++;
        $selector = 'wpmf-gallery-' . $instance;
        $gallery_configs      = get_option('wpmf_gallery_settings');
        $params = shortcode_atts(
            array(
                'gallery_id'   => $post ? $post->ID : 0,
                'display'      => '',
                'columns'      => 3,
                'gutterwidth'  => 5,
                'link'         => 'post',
                'size'         => 'thumbnail',
                'targetsize'   => 'large',
                'wpmf_orderby'      => 'post__in',
                'wpmf_order'        => 'ASC',
                'customlink'   => 0,
                'bottomspace'  => 'default',
                'hidecontrols' => 'false',
                'class'        => '',
                'include'      => '',
                'exclude'      => '',
                'display_tree' => 0,
                'display_tag'  => 0,
                'img_border_radius' => 0,
                'border_width' => 0,
                'border_color' => 'transparent',
                'border_style' => 'solid',
                'img_shadow' => '',
                'show_buttons' => $gallery_configs['theme']['flowslide_theme']['show_buttons'],
                'animation' => $gallery_configs['theme']['slider_theme']['animation'],
                'duration' => $gallery_configs['theme']['slider_theme']['duration'],
                'auto_animation' => $gallery_configs['theme']['slider_theme']['auto_animation']
            ),
            $attr,
            'gallery'
        );
        foreach ($params as $attr_key => $attr_value) {
            ${$attr_key} = $attr_value;
        }

        $id = intval($gallery_id);
        if (empty($attr['gallery_id'])) {
            return '';
        }

        $term_exist = get_term($id, WPMF_GALLERY_ADDON_TAXO);
        if (empty($term_exist)) {
            return '<h3>' . __('Gallery not found!', 'wp-media-folder-gallery-addon') . '</h3>';
        }
        $galleries           = get_option('wpmf_galleries');
        $relationships = get_option('wpmfgrl_relationships');
        $social = $this->getSocialHtml();

        if ($display === '') {
            $display = 'default';
            if (!empty($galleries[$id]['theme'])) {
                $display = $galleries[$id]['theme'];
            }
        }

        // get params from options
        $allow_themes = array(
            'default',
            'masonry',
            'portfolio',
            'slider',
            'flowslide',
            'square_grid',
            'material'
        );
        if (!in_array($display, $allow_themes)) {
            $display = 'default';
        }

        $params = array_merge($gallery_configs['theme'][$display . '_theme'], $attr);
        foreach ($params as $attr_key => $attr_value) {
            ${$attr_key} = $attr_value;
        }
        $caption_lightbox = wpmfGetOption('caption_lightbox_gallery');
        $hover_class = (isset($gallery_configs['hover_image']) && (int) $gallery_configs['hover_image'] === 0) ? ' hover_false' : ' hover_true';
        /* Query images */

        $tax_query = array();
        $tax_query[] = array(
            'taxonomy'         => WPMF_GALLERY_ADDON_TAXO,
            'field'            => 'term_id',
            'terms'            => $id,
            'include_children' => false
        );

        if (isset($relationships[$id])) {
            $tax_query['relation'] = 'OR';
            $tax_query[] = array(
                'taxonomy'         => WPMF_TAXO,
                'field'            => 'term_id',
                'terms'            => (int) $relationships[$id],
                'include_children' => false
            );
        }
        $args = array(
            'posts_per_page' => - 1,
            'post_status'    => 'any',
            'post_type'      => array('attachment'),
            'tax_query'      => $tax_query
        );

        if ($wpmf_orderby === 'post__in') {
            $args['meta_key'] = 'wpmf_gallery_order';
            $args['orderby']  = 'meta_value_num';
            $args['order']    = 'ASC';
        } else {
            $args['orderby'] = $wpmf_orderby;
            $args['order']   = $wpmf_order;
        }

        $query        = new WP_Query($args);
        $_attachments = $query->get_posts();
        $attachments  = array();
        foreach ($_attachments as $key => $val) {
            $attachments[$val->ID] = $_attachments[$key];
        }

        if ($link === 'file' || $link === 'none') {
            $customlink = false;
        } else {
            $customlink = true;
        }

        if (empty($attachments) && (int) $display_tree === 0) {
            return '';
        }

        if (is_feed()) {
            $output = "\n";
            foreach ($attachments as $att_id => $attachment) {
                $output .= wp_get_attachment_link($att_id, $size, true) . "\n";
            }
            return $output;
        }
        $columns    = intval($columns);
        $size_class = sanitize_html_class($size);

        $class      = array();
        $class[]    = 'gallery';

        if (!$customlink) {
            $class[] = 'gallery-link-' . $link;
        }

        /* Create output html */
        if (!is_admin()) {
            $this->enqueue($display, $display_tree);
        }
        wp_localize_script('wpmf-gallery-js', 'wpmfgallery', $this->localizeScript());

        $ctglr = get_term((int) $id, WPMF_GALLERY_ADDON_TAXO);
        $tags  = array();
        foreach ($_attachments as $value) {
            $img_tags = get_post_meta($value->ID, 'wpmf_img_tags', true);
            $img_tags = explode(',', $img_tags);
            foreach ($img_tags as $img_tag) {
                if (trim($img_tag) !== '') {
                    $tags[] = trim($img_tag);
                }
            }
        }

        if ((int) $display_tag === 1 && count(array_unique($tags)) > 0) {
            $classtag = 'wpmf-tags';
        } else {
            $classtag = '';
        }

        $output = '<div class="wpmf_gallery_wrap ' . $classtag . $hover_class . '" data-top-gallery-settings="' . esc_attr(json_encode($params)) . '" data-id="' . $id . '">';
        if (isset($display_tree) && (int) $display_tree === 1) {
            $output .= '<div class="wpmf_gallery_tree" data-id="' . $id . '"></div>';
            $output .= '<div class="wpmf_gallery_box" data-id="' . $id . '" data-theme="' . $display . '">';
        } else {
            $output .= '<div class="wpmf_gallery_box fullbox" data-id="' . $id . '" data-theme="' . $display . '">';
        }

        $output .= "<img class='loading_gallery' src='" . WPMF_GALLERY_ADDON_PLUGIN_URL . "/assets/images/Loading_icon.gif' style='display: none;' />";
        if ((int) $display_tag === 1 && count(array_unique($tags)) > 0) {
            $output .= '<div class="wpmf-gridblock-filters">';
            $output .= '<ul class="tabs gridblock-filter-categories">';
            $output .= '<li class="tab filter-all-control selected">';
            $output .= '<a data-filter="*">' . __('All', 'wp-media-folder-gallery-addon') . '</a>';
            $output .= '</li>';
            foreach (array_unique($tags) as $tag) {
                $tag    = htmlentities($tag);
                $output .= '<li class="tab filter-all-control">';
                $output .= '<a data-filter="' . $tag . '">' . strtoupper($tag) . '</a>';
                $output .= '</li>';
            }
            $output .= '</ul></div>';
        }

        ob_start();
        if (isset($display)) {
            if (file_exists(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/' . $display . '.php')) {
                require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/' . $display . '.php');
            } else {
                require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/default.php');
            }
        } else {
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/default.php');
        }

        $output .= ob_get_contents();
        ob_end_clean();
        $output .= '</div>';
        $output .= '</div>';
        return $output;
    }

    /**
     * Load scripts and styles
     *
     * @param string $display      Theme name
     * @param string $display_tree Show tree
     *
     * @return void
     */
    public function enqueue($display, $display_tree)
    {
        $settings = get_option('wpmf_gallery_settings');
        add_action('wp_footer', array($this, 'photoswipeFooter'));
        wp_enqueue_script('jquery');
        if (in_array($display, array('masonry', 'portfolio', 'square_grid')) || (int) $display_tree === 1) {
            wp_enqueue_script('jquery-masonry');
        }

        if (!isset($settings['progressive_loading']) || (int) $settings['progressive_loading'] === 1) {
            wp_enqueue_script(
                'wpmf-autobrower',
                WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/js/jquery.esn.autobrowse.js',
                array('jquery'),
                WPMF_GALLERY_ADDON_VERSION,
                true
            );
        }

        wp_enqueue_script(
            'wpmfglr-photoswipe-lib',
            WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/js/photoswipe/photoswipe-lib.min.js',
            array('jquery'),
            WPMF_GALLERY_ADDON_VERSION
        );

        wp_enqueue_script(
            'wpmfglr-photoswipe-ui-default',
            WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/js/photoswipe/photoswipe-ui-default.min.js',
            array('wpmfglr-photoswipe-lib'),
            WPMF_GALLERY_ADDON_VERSION
        );

        wp_enqueue_script(
            'wpmfglr-photoswipe',
            WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/js/photoswipe/photoswipe.js',
            array('wpmfglr-photoswipe-lib', 'wpmfglr-photoswipe-ui-default', 'jquery'),
            WPMF_GALLERY_ADDON_VERSION
        );

        wp_enqueue_style(
            'wpmfglr-photoswipe-lib',
            WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/css/photoswipe/photoswipe.css',
            false,
            WPMF_GALLERY_ADDON_VERSION
        );
        wp_enqueue_style(
            'wpmfglr-photoswipe-default-skin',
            WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/css/photoswipe/default-skin.css',
            false,
            WPMF_GALLERY_ADDON_VERSION
        );

        wp_enqueue_script(
            'wordpresscanvas-imagesloaded',
            WPMF_PLUGIN_URL . '/assets/js/display-gallery/imagesloaded.pkgd.min.js',
            array(),
            '3.1.5',
            true
        );

        if ($display === 'slider' || (int) $display_tree === 1) {
            wp_enqueue_style(
                'wpmf-flexslider-style',
                WPMF_PLUGIN_URL . 'assets/css/display-gallery/flexslider.css',
                array(),
                '2.4.0'
            );

            wp_enqueue_script(
                'wpmf-gallery-flexslider',
                WPMF_PLUGIN_URL . 'assets/js/display-gallery/flexslider/jquery.flexslider.js',
                array('jquery'),
                '2.0.0',
                true
            );
        }

        wp_enqueue_style(
            'wpmf-gallery-style',
            WPMF_PLUGIN_URL . '/assets/css/display-gallery/style-display-gallery.css',
            array(),
            WPMF_VERSION
        );

        if ($display === 'flowslide' || (int) $display_tree === 1) {
            wp_enqueue_script(
                'wpmf-flipster-js',
                WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/js/jquery.flipster.js',
                array('jquery'),
                WPMF_GALLERY_ADDON_VERSION,
                true
            );

            wp_enqueue_style(
                'wpmf-flipster-css',
                WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/css/jquery.flipster.css',
                array(),
                WPMF_GALLERY_ADDON_VERSION
            );
        }

        wp_enqueue_script(
            'wpmf-gallery-js',
            WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/js/gallery.js',
            array('jquery'),
            WPMF_GALLERY_ADDON_VERSION,
            true
        );

        wp_enqueue_script(
            'wpmf-gallery-tree-js',
            WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/js/gallery_navigation_front.js',
            array('jquery'),
            WPMF_GALLERY_ADDON_VERSION
        );

        $args = array(
            'hide_empty'                   => false,
            'taxonomy'                     => WPMF_GALLERY_ADDON_TAXO,
            'pll_get_terms_not_translated' => 1
        );

        $galleries            = get_categories($args);
        $galleries            = wpmfParentSort($galleries);
        wp_localize_script('wpmf-gallery-tree-js', 'wpmfgallerytree', array(
            'vars'  => array(
                'galleries' => $galleries
            )
        ));

        wp_enqueue_style(
            'wpmf-gallery-css',
            WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/css/gallery.css',
            array(),
            WPMF_GALLERY_ADDON_VERSION
        );
    }

    /**
     * Localize a script.
     * Works only if the script has already been added.
     *
     * @return array
     */
    public function localizeScript()
    {
        $option_current_theme = get_option('current_theme');
        $gallery_configs      = get_option('wpmf_gallery_settings');

        if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) {
            $progressive_loading = 0;
        } else {
            $progressive_loading = 1;
        }

        return array(
            'wpmf_current_theme'  => $option_current_theme,
            'gallery_configs'     => $gallery_configs,
            'progressive_loading' => (int) $progressive_loading,
            'wpmf_gallery_nonce'  => wp_create_nonce('wpmf_gallery_nonce'),
            'ajaxurl'             => admin_url('admin-ajax.php')
        );
    }

    /**
     * Generate html attachment link
     *
     * @param integer $id          Id of image
     * @param string  $size        Size of image
     * @param boolean $permalink   Permalink of image
     * @param string  $targetsize  Image size. Accepts any valid image size, or an array of width
     * @param boolean $customlink  Customlink
     * @param string  $link_target Target of link
     *
     * @return mixed|string
     */
    public function galleryGetAttachmentLink(
        $id = 0,
        $size = 'thumbnail',
        $permalink = false,
        $targetsize = 'large',
        $customlink = false,
        $link_target = '_self'
    ) {
        $id    = intval($id);
        $_post = get_post($id);
        $url   = wp_get_attachment_url($_post->ID);
        if (empty($_post) || ('attachment' !== $_post->post_type) || !$url) {
            return __('Missing Attachment', 'wp-media-folder-gallery-addon');
        }

        $lightbox = 0;
        $img      = wp_get_attachment_image_src($_post->ID, $targetsize);
        if ($customlink) {
            $url = get_post_meta($_post->ID, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            if ($url === '') {
                $url = get_attachment_link($_post->ID);
            }
        } elseif ($permalink) {
            $url = get_attachment_link($_post->ID);
        } elseif ($targetsize) {
            if (get_post_meta($id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
                $lightbox = 0;
                $url      = get_post_meta($_post->ID, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            } else {
                $lightbox = 1;
                $url      = $img[0];
            }
        }

        $caption_lightbox = wpmfGetOption('caption_lightbox_gallery');
        if (!empty($caption_lightbox)) {
            $post_title = esc_html($_post->post_excerpt);
        } else {
            $post_title = esc_html($_post->post_title);
        }

        if ($size && 'none' !== $size) {
            $link_text = wp_get_attachment_image($id, $size, false, array('data-type' => 'wpmfgalleryimg', 'id' => 'wpmfgalleryimg'));
        } else {
            $link_text = '';
        }

        if (trim($link_text) === '') {
            $link_text = $_post->post_title;
        }

        $current_theme = get_option('current_theme');
        if (isset($current_theme) && $current_theme === 'Gleam') {
            $tclass = 'fancybox';
        } else {
            $tclass = '';
        }
        $remote_video = get_post_meta($id, 'wpmf_remote_video_link', true);
        if (empty($remote_video)) {
            if ((int) $lightbox === 1) {
                $data_size = $img[1] . 'x' . $img[2];
                return apply_filters(
                    'wp_get_attachment_link',
                    '<a data-size="' . $data_size . '" class="wpmfgalleryaddonswipe ' . $tclass . ' not_video wpmf_gallery_lightbox"
 data-swipe="' . $lightbox . '" href="' . $url . '" title="' . $post_title . '" target="' . $link_target . '">' . $link_text . '</a>',
                    $id,
                    $size,
                    $permalink,
                    false,
                    false
                );
            } else {
                return apply_filters(
                    'wp_get_attachment_link',
                    '<a class="' . $tclass . ' not_video wpmf_gallery_lightbox wpmfgalleryaddonswipe" data-swipe="' . $lightbox . '"
 href="' . $url . '" title="' . $post_title . '" target="' . $link_target . '">' . $link_text . '</a>',
                    $id,
                    $size,
                    $permalink,
                    false,
                    false
                );
            }
        } else {
            return apply_filters(
                'wp_get_attachment_link',
                '<a class="' . $tclass . ' isvideo wpmf_gallery_lightbox wpmfgalleryaddonswipe" data-swipe="' . $lightbox . '"
 href="' . $remote_video . '" title="' . $post_title . '" target="' . $link_target . '">' . $link_text . '</a>',
                $id,
                $size,
                $permalink,
                false,
                false
            );
        }
    }

    /**
     * Add photoswipe button in footer
     *
     * @return void
     */
    public function photoswipeFooter()
    {
        ?>
        <div class="pswp wpmf_swp" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="pswp__bg"></div>
            <div class="pswp__scroll-wrap">
                <div class="pswp__container">
                    <div class="pswp__item"></div>
                    <div class="pswp__item"></div>
                    <div class="pswp__item"></div>
                </div>
                <div class="pswp__ui pswp__ui--hidden">
                    <div class="pswp__top-bar">
                        <div class="pswp__counter"></div>
                        <button class="pswp__button pswp__button--close" title="Close (Esc)"></button>
                        <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>
                        <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>
                        <div class="pswp__preloader">
                            <div class="pswp__preloader__icn">
                                <div class="pswp__preloader__cut">
                                    <div class="pswp__preloader__donut"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)">
                    </button>
                    <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)">
                    </button>
                    <div class="pswp__caption">
                        <div class="pswp__caption__center"></div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    /**
     * Load gallery
     *
     * @return void
     */
    public function loadGallery()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- load image gallery on frontend
        if (empty($_POST['gallery_id'])) {
            wp_send_json(array('status' => false));
        }

        $gallery_id = $_POST['gallery_id'];
        /* get all params */
        $galleries           = get_option('wpmf_galleries');
        $gallery_configs     = get_option('wpmf_gallery_settings');
        $social = $this->getSocialHtml();

        // get params
        $id = intval($gallery_id);
        if (empty($galleries[$id]['theme'])) {
            $display = 'default';
        } else {
            $display = $galleries[$id]['theme'];
        }

        $settings = $this->getSettingsFront($id, $_POST['settings'], $gallery_configs, $galleries, $display);
        foreach ($settings as $attr_key => $setting) {
            ${$attr_key} = $setting;
        }
        $caption_lightbox = wpmfGetOption('caption_lightbox_gallery');
        /* Query images */
        $args = array(
            'posts_per_page' => - 1,
            'post_status'    => 'any',
            'post_type'      => array('attachment'),
            'tax_query'      => array(
                array(
                    'taxonomy'         => WPMF_GALLERY_ADDON_TAXO,
                    'field'            => 'term_id',
                    'terms'            => $id,
                    'include_children' => false
                ),
            )
        );

        if ($orderby === 'post__in') {
            $args['meta_key'] = 'wpmf_gallery_order';
            $args['orderby']  = 'meta_value_num';
            $args['order']    = 'ASC';
        } else {
            $args['orderby'] = $orderby;
            $args['order']   = $order;
        }

        $query        = new WP_Query($args);
        $_attachments = $query->get_posts();
        $attachments  = array();
        foreach ($_attachments as $key => $val) {
            if (isset($_POST['tags']) && $_POST['tags'] !== '*') {
                $i_tags = get_post_meta($val->ID, 'wpmf_img_tags', true);
                $i_tags = explode(',', $i_tags);

                $i_trim_tags = array();
                foreach ($i_tags as $i_tag) {
                    $i_trim_tags[] = trim($i_tag);
                }
                if (in_array($_POST['tags'], $i_trim_tags)) {
                    $attachments[$val->ID] = $_attachments[$key];
                }
            } else {
                $attachments[$val->ID] = $_attachments[$key];
            }
        }

        $size_class = sanitize_html_class($size);
        $class      = array();
        $class[]    = 'gallery';
        if ($link === 'file' || $link === 'none') {
            $customlink = false;
        } else {
            $customlink = true;
        }

        if (!$customlink) {
            $class[] = 'gallery-link-' . $link;
        }

        /* Create output html */
        $output = '';
        $output .= "<img class='loading_gallery' src='" . WPMF_GALLERY_ADDON_PLUGIN_URL . "/assets/images/Loading_icon.gif' style='display: none;' />";

        // render Tabs
        $tag_value = (isset($_POST['tags'])) ? $_POST['tags'] : '*';
        $output .= $this->renderTabsFilter($display_tag, $_attachments, $tag_value);

        // phpcs:enable
        ob_start();
        if (isset($display)) {
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/' . $display . '.php');
        } else {
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/default.php');
        }

        $output .= ob_get_contents();
        ob_end_clean();
        wp_send_json(array('status' => true, 'html' => $output));
    }

    /**
     * Get settings front
     *
     * @param integer $id                      Gallery ID
     * @param array   $request_settings        Request settings
     * @param array   $gallery_default_configs Gallery default configs
     * @param array   $galleries               Gallery configs
     * @param string  $theme                   Gallery theme
     *
     * @return array
     */
    public function getSettingsFront($id, $request_settings, $gallery_default_configs, $galleries, $theme)
    {
        $default = array(
            'columns'      => 3,
            'gutterwidth'  => 5,
            'link'         => 'post',
            'size'         => 'thumbnail',
            'targetsize'   => 'large',
            'wpmf_orderby'      => 'post__in',
            'wpmf_order'        => 'ASC',
            'customlink'   => 0,
            'bottomspace'  => 'default',
            'hidecontrols' => 'false',
            'class'        => '',
            'include'      => '',
            'exclude'      => '',
            'display_tree' => 0,
            'display_tag'  => 0,
            'img_border_radius' => 0,
            'border_width' => 0,
            'border_color' => 'transparent',
            'border_style' => 'solid',
            'img_shadow' => '',
            'show_buttons' => 1,
            'animation' => 'slide',
            'duration' => 4000,
            'auto_animation' => 1
        );

        if (isset($request_settings)) {
            $settings = $request_settings;
        } else {
            $settings = array_merge($gallery_default_configs['theme'][$theme . '_theme'], $galleries[$id]);
        }

        $settings = array_merge($default, $settings);
        return $settings;
    }

    /**
     * Render tabs filter
     *
     * @param integer $enable       Enable or disable
     * @param array   $_attachments Attachments
     * @param string  $tag_value    Current tag value
     *
     * @return string
     */
    public function renderTabsFilter($enable, $_attachments, $tag_value)
    {
        ob_start();
        $html = '';
        if ((int) $enable === 1) {
            $tags   = array();
            foreach ($_attachments as $value) {
                $img_tags = get_post_meta($value->ID, 'wpmf_img_tags', true);
                $img_tags = explode(',', $img_tags);
                foreach ($img_tags as $img_tag) {
                    if (trim($img_tag) !== '') {
                        $tags[] = trim($img_tag);
                    }
                }
            }

            if (count(array_unique($tags)) > 0) {
                echo '<div class="wpmf-gridblock-filters">';
                echo '<ul class="tabs gridblock-filter-categories">';
                if (empty($tag_value) || (!empty($tag_value) && $tag_value === '*')) {
                    echo '<li class="tab filter-all-control selected">';
                } else {
                    echo '<li class="tab filter-all-control">';
                }

                echo '<a data-filter="*">' . esc_html__('All', 'wp-media-folder-gallery-addon') . '</a>';
                echo '</li>';
                foreach (array_unique($tags) as $tag) {
                    if ($tag !== '') {
                        $tag    = htmlentities($tag);
                        if ($tag === $tag_value) {
                            echo '<li class="tab filter-all-control selected">';
                        } else {
                            echo '<li class="tab filter-all-control">';
                        }

                        echo '<a data-filter="' . esc_attr($tag) . '" class="">' . esc_html(strtoupper($tag)) . '</a>';
                        echo '</li>';
                    }
                }
                echo '</ul></div>';
            }
        }

        $html .= ob_get_contents();
        ob_end_clean();

        return $html;
    }
}
