(function ($) {
    if (typeof ajaxurl === "undefined") {
        ajaxurl = wpmf.vars.ajaxurl;
    }
    $(document).ready(function () {
        if (typeof wp !== "undefined") {
            /**
             * options
             * @type {{root: string, showroot: *, onclick: onclick, oncheck: oncheck, usecheckboxes: boolean, expandSpeed: number, collapseSpeed: number, expandEasing: null, collapseEasing: null, canselect: boolean}}
             */
            var options = {
                'root': '/',
                'showroot': wpmf.l18n.assign_tree_label,
                'onclick': function (elem, type, file) {
                },
                'oncheck': function (elem, checked, type, file) {
                },
                'usecheckboxes': true, //can be true files dirs or false
                'expandSpeed': 500,
                'collapseSpeed': 500,
                'expandEasing': null,
                'collapseEasing': null,
                'canselect': true
            };

            /**
             * Main folder tree function
             * @type {{init: init, open: open, close: close}}
             */
            var methods = {
                /**
                 * Folder tree init
                 * @param o
                 */
                init: function (o) {
                    if ($(this).length === 0) {
                        return;
                    }
                    $librarytree = $(this);
                    $.extend(options, o);
                    if (wpmf.vars.wpmf_role === 'administrator') {
                        if (options.showroot !== '') {
                            var tree_init = '';
                            tree_init += '<ul class="jaofiletree glrjaofiletree">';
                            tree_init += '<li data-id="0" class="directory collapsed selected" data-group="' + wpmf.vars.wpmf_curent_userid + '">';
                            tree_init += '<div class="pure-checkbox">';
                            tree_init += '<input type="checkbox" id="/" class="wpmf_checkbox_tree" value="wpmf_' + wpmf.vars.root_media_root + '" data-id="' + wpmf.vars.root_media_root + '" data-file="/" data-type="dir">';
                            tree_init += '<label class="checked" for="/">';
                            tree_init += '<a for="/" class="title-folder title-root" data-id="0" data-file="' + options.root + '" data-type="dir">' + options.showroot + '</a>';
                            tree_init += '</label>';
                            tree_init += '</div>';
                            tree_init += '</li>';
                            tree_init += '</ul>';
                            $librarytree.html(tree_init);
                        }
                        openfolderlibrary(options.root);
                    } else {
                        if (parseInt(wpmf.vars.wpmf_active_media) === 1 && wpmf.vars.term_root_id) {
                            $librarytree.html('<ul class="jaofiletree glrjaofiletree"><li  data-id="' + wpmf.vars.term_root_id + '"  class="directory collapsed selected"><a class="title-folder title-root" data-id="' + wpmf.vars.term_root_id + '" data-file="/' + wpmflang.term_root_username + '/" data-type="dir">' + wpmflang.term_root_username + '</a><a class="title-wpmfaddFolder"><i class="material-icons wpmf_icon_newfolder wpmfaddFolder">create_new_folder</i></a></li></ul>');
                            openfolderlibrary('/' + wpmf.vars.term_root_username + '/');
                        } else {
                            if (options.showroot !== '') {
                                $librarytree.html('<ul class="jaofiletree glrjaofiletree"><li  data-id="0"  class="directory collapsed selected"><a class="title-folder title-root" data-id="0" data-file="' + options.root + '" data-type="dir">' + options.showroot + '</a><a class="title-wpmfaddFolder"><i class="material-icons wpmf_icon_newfolder wpmfaddFolder">create_new_folder</i></a></li></ul>');
                            }
                            openfolderlibrary(options.root);
                        }
                    }
                },
                /**
                 * open folder tree by dir name
                 * @param dir
                 */
                open: function (dir) {
                    openfolderlibrary(dir);
                },
                /**
                 * close folder tree by dir name
                 * @param dir
                 */
                close: function (dir) {
                    closedirlibrary(dir);
                }
            };

            /**
             * open folder by dir
             * @param dir dir name of the folders parent
             * @param callback
             */
            var openfolderlibrary = function (dir, callback) {
                if (typeof $librarytree === "undefined")
                    return;
                var id = $librarytree.find('a[data-file="' + dir + '"]').data('id');
                if ($librarytree.find('a[data-file="' + dir + '"]').closest('li').hasClass('expanded') || $librarytree.find('a[data-file="' + dir + '"]').closest('li').hasClass('wait')) {
                    if (typeof callback === 'function')
                        callback();
                    return;
                }
                var ret;
                ret = $.ajax({
                    method: 'POST',
                    url: ajaxurl,
                    data: {
                        dir: dir,
                        id: id,
                        action: 'wpmfgallery',
                        task: 'get_library_tree',
                        wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                    },
                    context: $librarytree,
                    dataType: 'json',
                    beforeSend: function () {
                        this.find('a[data-file="' + dir + '"]').closest('li').addClass('wait');
                    }
                }).done(function (res) {

                    var selectedId = $('#librarytree .directory.selected').data('id');
                    ret = '<ul class="jaofiletree">';
                    if (res.status) {
                        var datas = res.dirs;
                        for (var ij = 0; ij < datas.length; ij++) {
                            if (parseInt(wpmf.vars.root_media_root) !== datas[ij].id) {
                                if (datas[ij].type === 'dir') {
                                    var classe = 'directory collapsed';
                                } else {
                                    classe = 'file ext_' + datas[ij].ext;
                                }

                                if (parseInt(datas[ij].id) === parseInt(selectedId)) {
                                    classe += ' selected';
                                }

                                ret += '<li class="' + classe + '" data-id="' + datas[ij].id + '" data-parent_id="' + datas[ij].parent_id + '" data-group="' + datas[ij].term_group + '">';
                                if (datas[ij].count_child > 0) {
                                    ret += '<div class="icon-open-close" data-id="' + datas[ij].id + '" data-parent_id="' + datas[ij].parent_id + '" data-file="' + dir + datas[ij].file + '/" data-type="' + datas[ij].type + '"></div>';
                                } else {
                                    ret += '<div class="icon-open-close" data-id="' + datas[ij].id + '" data-parent_id="' + datas[ij].parent_id + '" data-file="' + dir + datas[ij].file + '/" data-type="' + datas[ij].type + '" style="opacity:0"></div>';
                                }

                                ret += '<div class="pure-checkbox">';

                                ret += '<input type="checkbox" id="' + dir + datas[ij].file + '/" class="wpmf_checkbox_tree" value="wpmf_' + datas[ij].id + '" data-id="' + datas[ij].id + '" data-file="' + dir + datas[ij].file + '" data-type="' + datas[ij].type + '">';
                                ret += '<label for="' + dir + datas[ij].file + '/">';

                                if (parseInt(datas[ij].id) === parseInt(selectedId)) {
                                    ret += '<i class="zmdi wpmf-zmdi-folder-open"></i>';
                                } else {
                                    ret += '<i class="zmdi zmdi-folder"></i>';
                                }
                                ret += '<a for="wpmf_' + datas[ij].id + '" class="title-folder" data-id="' + datas[ij].id + '" data-parent_id="' + datas[ij].parent_id + '" data-file="' + dir + datas[ij].file + '/" data-type="' + datas[ij].type + '">' + datas[ij].file + '</a>';
                                ret += '</label>';
                                ret += '</div';
                                ret += '</li>';
                            }
                        }
                    }
                    ret += '</ul>';

                    this.find('a[data-file="' + dir + '"]').closest('li').removeClass('wait').removeClass('collapsed').addClass('expanded');
                    this.find('a[data-file="' + dir + '"]').closest('li').append(ret);
                    this.find('a[data-file="' + dir + '"]').closest('li').children('.jaofiletree').slideDown(options.expandSpeed, options.expandEasing,
                        function () {
                            $librarytree.trigger('afteropen');
                            $librarytree.trigger('afterupdate');
                            if (typeof callback === 'function')
                                callback();
                        });

                    seteventslibrary();

                }).done(function () {
                    $librarytree.trigger('afteropen');
                    $librarytree.trigger('afterupdate');
                });
            };

            /**
             * close folder tree by dir name
             * @param dir
             */
            var closedirlibrary = function (dir) {
                if (typeof $librarytree === "undefined") {
                    return;
                }

                $librarytree.find('a[data-file="' + dir + '"]').closest('li').children('.jaofiletree').slideUp(options.collapseSpeed, options.collapseEasing, function () {
                    $(this).remove();
                });

                $librarytree.find('a[data-file="' + dir + '"]').closest('li').removeClass('expanded').addClass('collapsed');
                seteventslibrary();

                //Trigger custom event
                $librarytree.trigger('afterclose');
                $librarytree.trigger('afterupdate');
            };

            /**
             * init event click to open/close folder tree
             */
            var seteventslibrary = function () {
                $librarytree = $('#librarytree');
                $librarytree.find('li a,li .icon-open-close').unbind('click');
                //Bind for collapse or expand elements
                $librarytree.find('li.directory a').bind('click', function (e) {
                    e.preventDefault();
                    if (!$(this).hasClass('wpmfaddFolder')) {
                        if (page !== 'table') {
                            $librarytree.find('li').removeClass('selected');
                            $librarytree.find('i.zmdi').removeClass('wpmf-zmdi-folder-open').addClass("zmdi-folder");
                            $(this).closest('li').addClass("selected");
                            $(this).closest('li').find(' > .pure-checkbox i.zmdi').removeClass("zmdi-folder").addClass("wpmf-zmdi-folder-open");
                            methods.open($(this).attr('data-file'));
                        }
                    }

                });

                /* open folder tree use icon */
                $librarytree.find('li.directory.collapsed .icon-open-close').bind('click', function () {
                    methods.open($(this).attr('data-file'));
                });

                /* close folder tree use icon */
                $librarytree.find('li.directory.expanded .icon-open-close').bind('click', function () {
                    methods.close($(this).attr('data-file'));
                });

                /* check, uncheck folder */
                $librarytree.find('li.directory.expanded .wpmf_checkbox_tree').bind('click', function () {
                    if ($(this).is(':checked')) {
                        $(this).closest('li').removeClass('pchecked').addClass('checked');
                        $(this).closest('.pure-checkbox').find('label').removeClass('pchecked').addClass('checked');
                    } else {
                        $(this).closest('.pure-checkbox').find('label').removeClass('checked');
                        $(this).closest('li').removeClass('checked');
                    }
                });
            };

            /**
             * Folder tree function
             * @param method
             * @returns {*}
             */
            $.fn.librarytree = function (method) {
                // Method calling logic
                if (methods[method]) {
                    return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
                } else if (typeof method === 'object' || !method) {
                    return methods.init.apply(this, arguments);
                } else {
                    //error
                }
            };
        }
    });
}(jQuery));