'use strict';

/**
 * Folder tree for WP Media Folder
 */
var wpmfGalleryTree = void 0;
(function ($) {
    wpmfGalleryTree = {
        categories: [], // categories
        galleries_tree: {},
        /**
         * Initialize module related things
         */
        initModule: function initModule($current) {
            var gallery_id = $current.data('id'); // get gallery ID inserted content
            var k = 0;
            wpmfGalleryTree.categories = wpmfgallerytree.vars.galleries;
            wpmfGalleryTree.galleries_tree[gallery_id] = [];
            while (k < wpmfGalleryTree.categories.length) {
                if (wpmfGalleryTree.categories[k].term_id === gallery_id) {
                    wpmfGalleryTree.galleries_tree[gallery_id] = [wpmfGalleryTree.categories[k]];
                    wpmfGalleryTree.galleries_tree[gallery_id] = wpmfGalleryTree.getTree(wpmfGalleryTree.categories, wpmfGalleryTree.galleries_tree[gallery_id], gallery_id);
                }
                k++;
            }

            // Render the tree view
            wpmfGalleryTree.loadTreeView($current);

            var galleryIdStart = wpmfGalleryTree.getGalleryIDStart($current);
            var tree_hash = window.location.hash;
            tree_hash = tree_hash.replace('#', '');
            if (tree_hash !== '') {
                var hasha = tree_hash.split('-');
                if (hasha[1].indexOf('wpmfgallery') !== -1) {
                    var args = hasha[1].split('+');
                    if (galleryIdStart !== args[1]) {
                        wpmfGalleryTree.changeFolder($current, galleryIdStart, args[1]);
                        wpmfGalleryTree.loadGallery($current, galleryIdStart, args[1]);
                    }
                }
            }
        },

        /**
         * Render tree view inside content
         */
        loadTreeView: function loadTreeView($current) {
            var top_gallery_id = $current.data('id'); // get gallery ID inserted content
            $current.html(wpmfGalleryTree.getRendering($current));

            // Initialize double click to folder title on tree view
            $current.find('ul a[data-id]').on('click', function () {
                // single click
                var id = $(this).data('id');
                wpmfGalleryTree.changeFolder($current, id, top_gallery_id);
                wpmfGalleryTree.loadGallery($current, id, top_gallery_id);
            });
        },

        loadGallery: function loadGallery($current, galleryId, top_gallery_id) {
            var $container = $('.wpmf_gallery_tree[data-id="' + top_gallery_id + '"]').closest('.wpmf_gallery_wrap');
            var data = {
                action: "wpmf_load_gallery",
                gallery_id: galleryId
            };

            if (parseInt(galleryId) === parseInt(top_gallery_id)) {
                data.settings = $('.wpmf_gallery_wrap[data-id="' + galleryId + '"]').data('top-gallery-settings');
            }
            $.ajax({
                url: wpmfgallery.ajaxurl,
                method: "POST",
                dataType: 'json',
                data: data,
                beforeSend: function beforeSend() {
                    $container.find('.wpmf_gallery_box *').hide();
                    $container.find('.wpmf_gallery_box .loading_gallery').show();
                },
                success: function success(res) {
                    if (res.status) {
                        window.location.hash = '#' + galleryId + '-wpmfgallery+' + top_gallery_id;
                        $container.find('.wpmf_gallery_box').html('').append(res.html);
                        wpmfGallery.initGallery();
                    }
                }
            });
        },

        /**
         * Change the selected folder in tree view
         */
        changeFolder: function changeFolder($current, folder_id, top_gallery_id) {
            // Remove previous selection
            $('.wpmf_gallery_tree[data-id="' + top_gallery_id + '"]').find('li').removeClass('selected');

            // Select the folder
            $('.wpmf_gallery_tree[data-id="' + top_gallery_id + '"]').find('li[data-id="' + folder_id + '"]').addClass('selected'). // Open parent folders
            parents('.wpmf_gallery_tree li.closed').removeClass('closed');
        },

        getTree: function getTree(categories, trees, parent) {
            var ij = 0;
            var trees_sorted = [];
            while (ij < categories.length) {
                if (wpmfGalleryTree.categories[ij].parent === parent) {
                    trees_sorted.push(wpmfGalleryTree.categories[ij]);
                    wpmfGalleryTree.getTree(categories, trees_sorted, wpmfGalleryTree.categories[ij].term_id);
                }
                ij++;
            }

            trees_sorted = trees_sorted.sort(function (a, b) {
                return a.order - b.order;
            });
            $.each(trees_sorted, function () {
                trees.push(this);
            });

            return trees;
        },

        getGalleryIDStart: function getGalleryIDStart($current) {
            var gallery_id = $current.data('id'); // get gallery ID inserted content
            var tree_hash = window.location.hash;
            tree_hash = tree_hash.replace('#', '');
            if (tree_hash !== '') {
                var hasha = tree_hash.split('-');
                if (hasha[1].indexOf('wpmfgallery') !== -1) {
                    gallery_id = parseInt(hasha[0]);
                }
            }

            return gallery_id;
        },

        /**
         * Get the html resulting tree view
         * @return {string}
         */
        getRendering: function getRendering($current) {
            var ij = 0;
            var content = '';
            var gallery_id = $current.data('id'); // get gallery ID inserted content
            var galleries = wpmfGalleryTree.galleries_tree[gallery_id];
            /**
             * Recursively print list of folders
             * @return {boolean}
             */
            var generateList = function generateList() {
                var tree_class = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

                content += '<ul class="' + tree_class + '">';

                while (ij < galleries.length) {
                    var className = '';
                    if (galleries[ij].term_id === parseInt(gallery_id)) {
                        className += 'open selected ';
                    } else {
                        className += 'closed ';
                    }

                    // Open li tag
                    content += '<li class="' + className + '" data-id="' + galleries[ij].term_id + '" >';
                    var a_tag = '<a data-id="' + galleries[ij].term_id + '">';
                    if (galleries[ij + 1] && galleries[ij + 1].depth > galleries[ij].depth) {
                        // The next element is a sub folder
                        content += '<a onclick="wpmfGalleryTree.toggle(this, ' + galleries[ij].term_id + ')"><i class="material-icons wpmf-arrow">keyboard_arrow_down</i></a>';
                        content += a_tag;
                        content += '<i class="material-icons-outlined">photo_album</i>';
                    } else {
                        content += a_tag;
                        content += '<span class="wpmf-no-arrow"></span><i class="material-icons-outlined">photo_album</i>';
                    }

                    // Add current category name
                    content += '<span>' + galleries[ij].name + '</span>';
                    content += '</a>';

                    // This is the end of the array
                    if (galleries[ij + 1] === undefined) {
                        // Let's close all opened tags
                        for (var ik = galleries[ij].depth; ik >= 0; ik--) {
                            content += '</li>';
                            content += '</ul>';
                        }

                        // We are at the end don't continue to process array
                        return false;
                    }

                    if (galleries[ij + 1].depth > galleries[ij].depth) {
                        // The next element is a sub folder
                        // Recursively list it
                        ij++;
                        if (generateList() === false) {
                            // We have reached the end, let's recursively end
                            return false;
                        }
                    } else if (galleries[ij + 1].depth < galleries[ij].depth) {
                        // The next element don't have the same parent
                        // Let's close opened tags
                        for (var _ik = galleries[ij].depth; _ik > galleries[ij + 1].depth; _ik--) {
                            content += '</li>';
                            content += '</ul>';
                        }

                        // We're not at the end of the array let's continue processing it
                        return true;
                    }

                    // Close the current element
                    content += '</li>';
                    ij++;
                }
            };

            // Start generation
            generateList();
            return content;
        },

        /**
         * Toggle the open / closed state of a folder
         */
        toggle: function toggle(current, folder_id) {
            var $current = $(current).closest('.wpmf_gallery_tree');
            // Check is folder has closed class
            if ($current.find('li[data-id="' + folder_id + '"]').hasClass('closed')) {
                // Open the folder
                wpmfGalleryTree.openFolder($current, folder_id);
            } else {
                // Close the folder
                wpmfGalleryTree.closeFolder($current, folder_id);
                // close all sub folder
                $('li[data-id="' + folder_id + '"]').find('li').addClass('closed');
            }
        },

        /**
         * Open a folder to show children
         */
        openFolder: function openFolder($current, folder_id) {
            $current.find('li[data-id="' + folder_id + '"]').removeClass('closed');
        },

        /**
         * Close a folder and hide children
         */
        closeFolder: function closeFolder($current, folder_id) {
            $current.find('li[data-id="' + folder_id + '"]').addClass('closed');
        }
    };

    // Let's initialize WPMF folder tree features
    $(document).ready(function () {
        $('.wpmf_gallery_tree').each(function () {
            wpmfGalleryTree.initModule($(this));
        });
    });
})(jQuery);
