/**
 * Folder tree for WP Media Folder
 */
let wpmfGalleryTree;
(function ($) {
    wpmfGalleryTree = {
        categories: [], // categories
        galleries_tree: {},
        /**
         * Initialize module related things
         */
        initModule: function ($current) {
            let gallery_id = $current.data('id');  // get gallery ID inserted content
            let k = 0;
            wpmfGalleryTree.categories = wpmfgallerytree.vars.galleries;
            wpmfGalleryTree.galleries_tree[gallery_id] = [];
            while (k < wpmfGalleryTree.categories.length) {
                if (wpmfGalleryTree.categories[k].term_id === gallery_id) {
                    wpmfGalleryTree.galleries_tree[gallery_id] = [wpmfGalleryTree.categories[k]];
                    wpmfGalleryTree.galleries_tree[gallery_id] = wpmfGalleryTree.getTree(wpmfGalleryTree.categories, wpmfGalleryTree.galleries_tree[gallery_id], gallery_id);
                }
                k++;
            }

            // Render the tree view
            wpmfGalleryTree.loadTreeView($current);

            let galleryIdStart = wpmfGalleryTree.getGalleryIDStart($current);
            let tree_hash = window.location.hash;
            tree_hash = tree_hash.replace('#', '');
            if (tree_hash !== '') {
                let hasha = tree_hash.split('-');
                if (hasha[1].indexOf('wpmfgallery') !== -1) {
                    let args = hasha[1].split('+');
                    if (galleryIdStart !== args[1]) {
                        wpmfGalleryTree.changeFolder($current, galleryIdStart, args[1]);
                        wpmfGalleryTree.loadGallery($current, galleryIdStart, args[1]);
                    }
                }
            }
        },

        /**
         * Render tree view inside content
         */
        loadTreeView: function ($current) {
            let top_gallery_id = $current.data('id');  // get gallery ID inserted content
            $current.html(wpmfGalleryTree.getRendering($current));

            // Initialize double click to folder title on tree view
            $current.find('ul a[data-id]').on('click', function () {
                // single click
                let id = $(this).data('id');
                wpmfGalleryTree.changeFolder($current, id, top_gallery_id);
                wpmfGalleryTree.loadGallery($current, id, top_gallery_id);
            });
        },

        loadGallery: function ($current, galleryId, top_gallery_id) {
            var $container = $('.wpmf_gallery_tree[data-id="' + top_gallery_id + '"]').closest('.wpmf_gallery_wrap');
            var data = {
                action: "wpmf_load_gallery",
                gallery_id: galleryId,
            };

            if (parseInt(galleryId) === parseInt(top_gallery_id)) {
                data.settings = $('.wpmf_gallery_wrap[data-id="' + galleryId + '"]').data('top-gallery-settings');
            }
            $.ajax({
                url: wpmfgallery.ajaxurl,
                method: "POST",
                dataType: 'json',
                data: data,
                beforeSend: function () {
                    $container.find('.wpmf_gallery_box *').hide();
                    $container.find('.wpmf_gallery_box .loading_gallery').show();
                },
                success: function (res) {
                    if (res.status) {
                        window.location.hash = '#' + galleryId + '-wpmfgallery+' + top_gallery_id;
                        $container.find('.wpmf_gallery_box').html('').append(res.html);
                        wpmfGallery.initGallery();
                    }
                }
            });
        },

        /**
         * Change the selected folder in tree view
         */
        changeFolder: function ($current, folder_id, top_gallery_id) {
            // Remove previous selection
            $('.wpmf_gallery_tree[data-id="' + top_gallery_id + '"]').find('li').removeClass('selected');

            // Select the folder
            $('.wpmf_gallery_tree[data-id="' + top_gallery_id + '"]').find('li[data-id="' + folder_id + '"]').addClass('selected').// Open parent folders
            parents('.wpmf_gallery_tree li.closed').removeClass('closed');
        },

        getTree: function (categories, trees, parent) {
            let ij = 0;
            let trees_sorted = [];
            while (ij < categories.length) {
                if (wpmfGalleryTree.categories[ij].parent === parent) {
                    trees_sorted.push(wpmfGalleryTree.categories[ij]);
                    wpmfGalleryTree.getTree(categories, trees_sorted, wpmfGalleryTree.categories[ij].term_id);
                }
                ij++;
            }

            trees_sorted = trees_sorted.sort(function(a, b){return a.order - b.order});
            $.each(trees_sorted, function () {
                trees.push(this);
            });

            return trees;
        },

        getGalleryIDStart: function ($current) {
            let gallery_id = $current.data('id');  // get gallery ID inserted content
            let tree_hash = window.location.hash;
            tree_hash = tree_hash.replace('#', '');
            if (tree_hash !== '') {
                let hasha = tree_hash.split('-');
                if (hasha[1].indexOf('wpmfgallery') !== -1) {
                    gallery_id = parseInt(hasha[0]);
                }
            }

            return gallery_id;
        },

        /**
         * Get the html resulting tree view
         * @return {string}
         */
        getRendering: function ($current) {
            let ij = 0;
            let content = '';
            let gallery_id = $current.data('id');  // get gallery ID inserted content
            let galleries = wpmfGalleryTree.galleries_tree[gallery_id];
            /**
             * Recursively print list of folders
             * @return {boolean}
             */
            const generateList = function (tree_class = '') {
                content += '<ul class="' + tree_class + '">';

                while (ij < galleries.length) {
                    let className = '';
                    if (galleries[ij].term_id === parseInt(gallery_id)) {
                        className += 'open selected ';
                    } else {
                        className += 'closed ';
                    }

                    // Open li tag
                    content += '<li class="' + className + '" data-id="' + galleries[ij].term_id + '" >';
                    const a_tag = '<a data-id="' + galleries[ij].term_id + '">';
                    if (galleries[ij + 1] && galleries[ij + 1].depth > galleries[ij].depth) { // The next element is a sub folder
                        content += '<a onclick="wpmfGalleryTree.toggle(this, ' + galleries[ij].term_id + ')"><i class="material-icons wpmf-arrow">keyboard_arrow_down</i></a>';
                        content += a_tag;
                        content += '<i class="material-icons-outlined">photo_album</i>';
                    } else {
                        content += a_tag;
                        content += '<span class="wpmf-no-arrow"></span><i class="material-icons-outlined">photo_album</i>';
                    }

                    // Add current category name
                    content += '<span>' + galleries[ij].name + '</span>';
                    content += '</a>';

                    // This is the end of the array
                    if (galleries[ij + 1] === undefined) {
                        // Let's close all opened tags
                        for (let ik = galleries[ij].depth; ik >= 0; ik--) {
                            content += '</li>';
                            content += '</ul>';
                        }

                        // We are at the end don't continue to process array
                        return false;
                    }

                    if (galleries[ij + 1].depth > galleries[ij].depth) { // The next element is a sub folder
                        // Recursively list it
                        ij++;
                        if (generateList() === false) {
                            // We have reached the end, let's recursively end
                            return false;
                        }
                    } else if (galleries[ij + 1].depth < galleries[ij].depth) { // The next element don't have the same parent
                        // Let's close opened tags
                        for (let ik = galleries[ij].depth; ik > galleries[ij + 1].depth; ik--) {
                            content += '</li>';
                            content += '</ul>';
                        }

                        // We're not at the end of the array let's continue processing it
                        return true;
                    }

                    // Close the current element
                    content += '</li>';
                    ij++;
                }
            };

            // Start generation
            generateList();
            return content;
        },

        /**
         * Toggle the open / closed state of a folder
         */
        toggle: function (current, folder_id) {
            let $current = $(current).closest('.wpmf_gallery_tree');
            // Check is folder has closed class
            if ($current.find('li[data-id="' + folder_id + '"]').hasClass('closed')) {
                // Open the folder
                wpmfGalleryTree.openFolder($current, folder_id);
            } else {
                // Close the folder
                wpmfGalleryTree.closeFolder($current, folder_id);
                // close all sub folder
                $('li[data-id="' + folder_id + '"]').find('li').addClass('closed');
            }
        },

        /**
         * Open a folder to show children
         */
        openFolder: function ($current, folder_id) {
            $current.find('li[data-id="' + folder_id + '"]').removeClass('closed');
        },

        /**
         * Close a folder and hide children
         */
        closeFolder: function ($current, folder_id) {
            $current.find('li[data-id="' + folder_id + '"]').addClass('closed');
        },
    };

    // Let's initialize WPMF folder tree features
    $(document).ready(function () {
        $('.wpmf_gallery_tree').each(function () {
            wpmfGalleryTree.initModule($(this));
        });
    });
})(jQuery);