var wpmfGallery;
(function ($) {
    wpmfGallery = {
        wpmf_img_tags: '*',
        gallery_items: [],
        /* Init gallery */
        initGallery: function () {
            $('.wpmf_gallery_wrap .flipster').each(function () {
                var $flip = $(this);
                imagesLoaded($flip, function () {
                    var enableNavButtons = $flip.data('button');
                    if (typeof enableNavButtons !== "undefined" && parseInt(enableNavButtons) === 1) {
                        $flip.flipster({
                            style: 'coverflow',
                            buttons: 'custom',
                            spacing: 0,
                            loop: true,
                            autoplay: 5000,
                            buttonNext: '<i class="flipto-next material-icons"> keyboard_arrow_right </i>',
                            buttonPrev: '<i class="flipto-prev material-icons"> keyboard_arrow_left </i>',
                            onItemSwitch: function (currentItem, previousItem) {
                                $flip.find('.flipster__container').height($(currentItem).height());
                            },
                            onItemStart: function (currentItem) {
                                $flip.find('.flipster__container').height($(currentItem).height());
                            }
                        });
                    } else {
                        $flip.flipster({
                            style: 'coverflow',
                            spacing: 0,
                            loop: true,
                            autoplay: 5000,
                            onItemSwitch: function (currentItem, previousItem) {
                                $flip.find('.flipster__container').height($(currentItem).height());
                            },
                            onItemStart: function (currentItem) {
                                $flip.find('.flipster__container').height($(currentItem).height());
                            }
                        });
                    }
                });
            });

            /* re-call event with tags */
            wpmfGallery.wpmfEventGalleryTags();
            $('.wpmf-gallerys-addon').each(function () {
                var id = $(this).data('id');
                var $container = $(this);
                if ($container.find('.gallery-masonry').length) {
                    if ($container.find('.gallery').is(':hidden')) {
                        return;
                    }

                    if ($container.find('.gallery').hasClass('masonry')) {
                        return;
                    }
                    imagesLoaded($container.find('.gallery'), function () {
                        wpmfGallery.galleryRunMasonry(400, $container, id);
                        $container.find('.gallery').css('visibility', 'visible');
                    });
                } else if ($container.find('.glrdefault').length) {
                    // make image same line
                    var columns = $container.find('.glrdefault').data('wpmfcolumns');
                    imagesLoaded($container.find('.glrdefault'), function () {
                        $container.find('figure').each(function (j, v) {
                            if ((j + 1) % columns === 0) {
                                $container.find('figure:nth(' + (j) + ')').after('<hr class="wpmfglr-line-break" />');
                            }
                        });
                        wpmfGallery.wpmfAutobrowse(id, $container.find('.glrdefault'), 'default');
                    });
                }
            });

            /* window load */
            $(window).load(function () {
                $('.flex-viewport').each(function () {
                    var first_image_height = $(this).find('ul.slides li:first-child img').css('height');
                    $(this).css('height', first_image_height + ' !important');
                });
            });

            /* init flexslider theme */
            if (jQuery().flexslider) {
                $('.icon-chevron-right').on('click', function () {
                    $(this).parent().find('.flex-next').click();
                });

                $('.icon-chevron-left').on('click', function () {
                    $(this).parent().find('.flex-prev').click();
                });

                $('.gallery_addon_flexslider').each(function () {
                    var $this = $(this);
                    var id = $(this).data('id');
                    if ($this.is(':hidden')) {
                        return;
                    }

                    if ($this.hasClass('flexslider-is-active')) {
                        return;
                    }

                    var animation = $this.data('animation');
                    var duration = parseInt($this.data('duration'));
                    var columns = parseInt($this.data('wpmfcolumns'));
                    var margin = parseInt($this.data('gutterwidth'));
                    var auto_animation = parseInt($this.data('auto_animation'));
                    var n = 0;
                    if (parseInt(margin) >= 10) {
                        n = 20;
                    }

                    var columns_width = ($this.width() - n - (columns - 1) * margin) / columns;
                    $this.addClass('flexslider-is-active');
                    if (columns > 1) {
                        $this.flexslider({
                            animation: animation,
                            animationLoop: true,
                            slideshow: (auto_animation === 1),
                            smoothHeight: (animation === 'fade'),
                            itemWidth: (animation === 'fade') ? 0 : columns_width,
                            itemMargin: margin,
                            pauseOnHover: true,
                            slideshowSpeed: duration,
                            prevText: "",
                            nextText: "",
                            start: function () {
                                $('.entry-content').removeClass('loading');
                            }
                        });
                    } else {
                        $this.flexslider({
                            animation: animation,
                            animationLoop: true,
                            itemWidth: $this.width(),
                            slideshow: (auto_animation === 1),
                            smoothHeight: true,
                            pauseOnHover: true,
                            slideshowSpeed: duration,
                            prevText: "",
                            nextText: "",
                            start: function () {
                                $('.entry-content').removeClass('loading');
                            }
                        });
                    }
                });
            }
        },

        /**
         * get column width, gutter width, count columns
         * @param $container
         * @returns {{columnWidth: number, gutterWidth, columns: Number}}
         */
        calculateGrid: function ($container) {
            var columns = parseInt($container.data('wpmfcolumns'));
            var gutterWidth = $container.data('gutter-width');
            var containerWidth = $container.width();

            if (isNaN(gutterWidth)) {
                gutterWidth = 5;
            } else if (gutterWidth > 50 || gutterWidth < 0) {
                gutterWidth = 5;
            }

            if (parseInt(columns) < 2 || containerWidth <= 450) {
                columns = 2;
            }

            gutterWidth = parseInt(gutterWidth);

            var allGutters = gutterWidth * (columns - 1);
            var contentWidth = containerWidth - allGutters;

            var columnWidth = Math.floor(contentWidth / columns);
            return {columnWidth: columnWidth, gutterWidth: gutterWidth, columns: columns};
        },

        /**
         * Run masonry gallery
         * @param duration
         * @param $container
         * @param id
         */
        galleryRunMasonry: function (duration, $container, id) {
            if ($container.find('.gallery').hasClass('masonry')) {
                return;
            }
            if ($container.is(':hidden')) {
                return;
            }
            var container = $container.find('.gallery-masonry');
            var $postBox = container.children('.wpmf-gallery-item');
            var o = wpmfGallery.calculateGrid($(container));
            var padding = o.gutterWidth;
            $postBox.css({'width': o.columnWidth + 'px', 'margin-bottom': padding + 'px'});
            $(container).masonry({
                itemSelector: '.wpmf-gallery-item',
                columnWidth: o.columnWidth,
                gutter: padding,
                isAnimated: true,
                animationOptions: {
                    duration: duration,
                    easing: 'linear',
                    queue: false
                },
                isFitWidth: true
            });

            if ($(container).hasClass('gallery-portfolio')) {
                var w = $(container).find('.attachment-thumbnail').width();
                $(container).find('.wpmf-caption-text.wpmf-gallery-caption , .gallery-icon').css('max-width', w + 'px');
            }
            wpmfGallery.wpmfAutobrowse(id, container, 'masonry', o.columnWidth, padding);
        },

        /**
         * lazy load images in gallery
         * @param id theme id
         * @param container container parent of items
         * @param theme_type theme type
         * @param column_width item width
         * @param padding item padding
         */
        wpmfAutobrowse: function (id, container, theme_type, column_width, padding) {
            if (parseInt(wpmfgallery.progressive_loading) === 0) {
                return;
            }

            wpmfGallery.gallery_items[id] = $(container).data('item');
            var number = 1;
            var offset = 1;
            if (theme_type !== 'masonry') {
                number = 3;
                offset = 3;
            }
            var current = 0;
            container.autobrowse(
                {
                    url: false,
                    timeout: 100,
                    template: function (response) {
                        var elems = [];
                        for (var i = 0; i < number && i + current < wpmfGallery.gallery_items[id].length; i++) {
                            var el = $(wpmfGallery.gallery_items[id][i + current]);
                            elems[i] = $(el).get(0);
                            if (theme_type === 'masonry') {
                                $($(el).get(0)).hide().appendTo(container);
                            } else {
                                $($(el).get(0)).hide().appendTo(container).fadeIn(800);
                            }

                        }

                        current += number;
                        if (theme_type === 'masonry') {
                            $(container).imagesLoaded(function () {
                                $(elems).css({
                                    'width': column_width + 'px',
                                    'margin-bottom': padding + 'px',
                                    'opacity': 0
                                }).show();

                                $(container).masonry('appended', $(elems));
                                $(elems).animate({
                                    opacity: 1,
                                }, 100, function() {
                                    // Animation complete.
                                });
                            });
                        }

                    },
                    itemsReturned: function (response) {
                        if (current >= wpmfGallery.gallery_items[id].length) {
                            return 0;
                        }
                        return number;
                    },
                    offset: offset
                }
            );
        },

        /* init tags event */
        wpmfEventGalleryTags: function () {
            $('.filter-all-control a').unbind('click').bind('click', function () {
                var $this = $(this);
                var galleryId = $this.closest('.wpmf_gallery_box').data('id');
                var $tree = $('.wpmf_gallery_tree[data-id="' + galleryId + '"]');
                var $container = $this.closest('.wpmf_gallery_wrap');
                var img_tags = $(this).data('filter');
                if (typeof img_tags !== "undefined") {
                    wpmfGallery.wpmf_img_tags = img_tags;
                }

                /* Load gallery */
                var data = {
                    action: "wpmf_load_gallery",
                    gallery_id: galleryId,
                    tags: wpmfGallery.wpmf_img_tags,
                    wpmf_gallery_nonce: wpmfgallery.wpmf_gallery_nonce
                };

                if ($tree.length) {
                    var current = $tree.find('li.selected').data('id');
                    if (current === galleryId) {
                        data.settings = $('.wpmf_gallery_wrap[data-id="' + galleryId + '"]').data('top-gallery-settings');
                    }
                    data.gallery_id = current;
                } else {
                    data.settings = $('.wpmf_gallery_wrap[data-id="' + galleryId + '"]').data('top-gallery-settings');
                }

                $.ajax({
                    url: wpmfgallery.ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: data,
                    beforeSend: function () {
                        $container.find('.wpmf_gallery_box *').hide();
                        $container.find('.wpmf_gallery_box .loading_gallery').show();
                    },
                    success: function (res) {
                        if (res.status) {
                            $this.closest('.wpmf_gallery_box').find('.loading_gallery').hide();
                            $container.find('.wpmf_gallery_box').html('').append(res.html);
                            wpmfGallery.initGallery();
                        }
                    }
                });
            });
        }
    };

    $(document).ready(function () {
        if (wpmfgallery.wpmf_current_theme === 'Gleam') {
            setTimeout(function () {
                wpmfGallery.initGallery();
            }, 1000);
        } else {
            wpmfGallery.initGallery();
        }

        setTimeout(function () {
            $('.responsive-tabs__list__item').on('click', function () {
                var target = $(this).attr('aria-controls');
                var container = $('#' + target).find('.wpmf-gallerys-addon');
                if (container.length) {
                    var id = container.data('id');
                    wpmfGallery.galleryRunMasonry(400, container, id);
                }
            });

            $('.tabtitle.responsive-tabs__heading').on('click', function () {
                var container = $(this).next('.tabcontent.responsive-tabs__panel').find('.wpmf-gallerys-addon');
                if (container.length) {
                    var id = container.data('id');
                    wpmfGallery.galleryRunMasonry(400, container, id);
                }
            });
        }, 1000);
    });

    $(document.body).on('post-load', function () {
        wpmfGallery.initGallery();
    });

    $(document.body).on('wpmfs-toggled', function () {
        wpmfGallery.initGallery();
    });
})(jQuery);
