<?php

// This file was auto-generated from sdk-root/src/data/amplify/2017-07-25/api-2.json
return ['version' => '2.0', 'metadata' => ['apiVersion' => '2017-07-25', 'endpointPrefix' => 'amplify', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceAbbreviation' => 'Amplify', 'serviceFullName' => 'AWS Amplify', 'serviceId' => 'Amplify', 'signatureVersion' => 'v4', 'signingName' => 'amplify', 'uid' => 'amplify-2017-07-25'], 'operations' => ['CreateApp' => ['name' => 'CreateApp', 'http' => ['method' => 'POST', 'requestUri' => '/apps'], 'input' => ['shape' => 'CreateAppRequest'], 'output' => ['shape' => 'CreateAppResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException'], ['shape' => 'LimitExceededException'], ['shape' => 'DependentServiceFailureException']]], 'CreateBranch' => ['name' => 'CreateBranch', 'http' => ['method' => 'POST', 'requestUri' => '/apps/{appId}/branches'], 'input' => ['shape' => 'CreateBranchRequest'], 'output' => ['shape' => 'CreateBranchResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'NotFoundException'], ['shape' => 'InternalFailureException'], ['shape' => 'LimitExceededException'], ['shape' => 'DependentServiceFailureException']]], 'CreateDomainAssociation' => ['name' => 'CreateDomainAssociation', 'http' => ['method' => 'POST', 'requestUri' => '/apps/{appId}/domains'], 'input' => ['shape' => 'CreateDomainAssociationRequest'], 'output' => ['shape' => 'CreateDomainAssociationResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'NotFoundException'], ['shape' => 'InternalFailureException'], ['shape' => 'LimitExceededException'], ['shape' => 'DependentServiceFailureException']]], 'DeleteApp' => ['name' => 'DeleteApp', 'http' => ['method' => 'DELETE', 'requestUri' => '/apps/{appId}'], 'input' => ['shape' => 'DeleteAppRequest'], 'output' => ['shape' => 'DeleteAppResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'NotFoundException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException'], ['shape' => 'DependentServiceFailureException']]], 'DeleteBranch' => ['name' => 'DeleteBranch', 'http' => ['method' => 'DELETE', 'requestUri' => '/apps/{appId}/branches/{branchName}'], 'input' => ['shape' => 'DeleteBranchRequest'], 'output' => ['shape' => 'DeleteBranchResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'NotFoundException'], ['shape' => 'InternalFailureException'], ['shape' => 'DependentServiceFailureException']]], 'DeleteDomainAssociation' => ['name' => 'DeleteDomainAssociation', 'http' => ['method' => 'DELETE', 'requestUri' => '/apps/{appId}/domains/{domainName}'], 'input' => ['shape' => 'DeleteDomainAssociationRequest'], 'output' => ['shape' => 'DeleteDomainAssociationResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'NotFoundException'], ['shape' => 'InternalFailureException'], ['shape' => 'DependentServiceFailureException']]], 'DeleteJob' => ['name' => 'DeleteJob', 'http' => ['method' => 'DELETE', 'requestUri' => '/apps/{appId}/branches/{branchName}/jobs/{jobId}'], 'input' => ['shape' => 'DeleteJobRequest'], 'output' => ['shape' => 'DeleteJobResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException'], ['shape' => 'NotFoundException'], ['shape' => 'LimitExceededException']]], 'GetApp' => ['name' => 'GetApp', 'http' => ['method' => 'GET', 'requestUri' => '/apps/{appId}'], 'input' => ['shape' => 'GetAppRequest'], 'output' => ['shape' => 'GetAppResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'NotFoundException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException']]], 'GetBranch' => ['name' => 'GetBranch', 'http' => ['method' => 'GET', 'requestUri' => '/apps/{appId}/branches/{branchName}'], 'input' => ['shape' => 'GetBranchRequest'], 'output' => ['shape' => 'GetBranchResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'NotFoundException'], ['shape' => 'InternalFailureException']]], 'GetDomainAssociation' => ['name' => 'GetDomainAssociation', 'http' => ['method' => 'GET', 'requestUri' => '/apps/{appId}/domains/{domainName}'], 'input' => ['shape' => 'GetDomainAssociationRequest'], 'output' => ['shape' => 'GetDomainAssociationResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'NotFoundException'], ['shape' => 'InternalFailureException']]], 'GetJob' => ['name' => 'GetJob', 'http' => ['method' => 'GET', 'requestUri' => '/apps/{appId}/branches/{branchName}/jobs/{jobId}'], 'input' => ['shape' => 'GetJobRequest'], 'output' => ['shape' => 'GetJobResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException'], ['shape' => 'NotFoundException'], ['shape' => 'LimitExceededException']]], 'ListApps' => ['name' => 'ListApps', 'http' => ['method' => 'GET', 'requestUri' => '/apps'], 'input' => ['shape' => 'ListAppsRequest'], 'output' => ['shape' => 'ListAppsResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException']]], 'ListBranches' => ['name' => 'ListBranches', 'http' => ['method' => 'GET', 'requestUri' => '/apps/{appId}/branches'], 'input' => ['shape' => 'ListBranchesRequest'], 'output' => ['shape' => 'ListBranchesResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException']]], 'ListDomainAssociations' => ['name' => 'ListDomainAssociations', 'http' => ['method' => 'GET', 'requestUri' => '/apps/{appId}/domains'], 'input' => ['shape' => 'ListDomainAssociationsRequest'], 'output' => ['shape' => 'ListDomainAssociationsResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException']]], 'ListJobs' => ['name' => 'ListJobs', 'http' => ['method' => 'GET', 'requestUri' => '/apps/{appId}/branches/{branchName}/jobs'], 'input' => ['shape' => 'ListJobsRequest'], 'output' => ['shape' => 'ListJobsResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException'], ['shape' => 'LimitExceededException']]], 'StartJob' => ['name' => 'StartJob', 'http' => ['method' => 'POST', 'requestUri' => '/apps/{appId}/branches/{branchName}/jobs'], 'input' => ['shape' => 'StartJobRequest'], 'output' => ['shape' => 'StartJobResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException'], ['shape' => 'NotFoundException'], ['shape' => 'LimitExceededException']]], 'StopJob' => ['name' => 'StopJob', 'http' => ['method' => 'DELETE', 'requestUri' => '/apps/{appId}/branches/{branchName}/jobs/{jobId}/stop'], 'input' => ['shape' => 'StopJobRequest'], 'output' => ['shape' => 'StopJobResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException'], ['shape' => 'NotFoundException'], ['shape' => 'LimitExceededException']]], 'UpdateApp' => ['name' => 'UpdateApp', 'http' => ['method' => 'POST', 'requestUri' => '/apps/{appId}'], 'input' => ['shape' => 'UpdateAppRequest'], 'output' => ['shape' => 'UpdateAppResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'NotFoundException'], ['shape' => 'UnauthorizedException'], ['shape' => 'InternalFailureException']]], 'UpdateBranch' => ['name' => 'UpdateBranch', 'http' => ['method' => 'POST', 'requestUri' => '/apps/{appId}/branches/{branchName}'], 'input' => ['shape' => 'UpdateBranchRequest'], 'output' => ['shape' => 'UpdateBranchResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'NotFoundException'], ['shape' => 'InternalFailureException'], ['shape' => 'DependentServiceFailureException']]], 'UpdateDomainAssociation' => ['name' => 'UpdateDomainAssociation', 'http' => ['method' => 'POST', 'requestUri' => '/apps/{appId}/domains/{domainName}'], 'input' => ['shape' => 'UpdateDomainAssociationRequest'], 'output' => ['shape' => 'UpdateDomainAssociationResult'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'UnauthorizedException'], ['shape' => 'NotFoundException'], ['shape' => 'InternalFailureException'], ['shape' => 'DependentServiceFailureException']]]], 'shapes' => ['ActiveJobId' => ['type' => 'string', 'max' => 1000], 'App' => ['type' => 'structure', 'required' => ['appId', 'appArn', 'name', 'description', 'repository', 'platform', 'createTime', 'updateTime', 'environmentVariables', 'defaultDomain', 'enableBranchAutoBuild', 'enableBasicAuth'], 'members' => ['appId' => ['shape' => 'AppId'], 'appArn' => ['shape' => 'AppArn'], 'name' => ['shape' => 'Name'], 'tags' => ['shape' => 'Tags'], 'description' => ['shape' => 'Description'], 'repository' => ['shape' => 'Repository'], 'platform' => ['shape' => 'Platform'], 'createTime' => ['shape' => 'CreateTime'], 'updateTime' => ['shape' => 'UpdateTime'], 'iamServiceRoleArn' => ['shape' => 'ServiceRoleArn'], 'environmentVariables' => ['shape' => 'EnvironmentVariables'], 'defaultDomain' => ['shape' => 'DefaultDomain'], 'enableBranchAutoBuild' => ['shape' => 'EnableBranchAutoBuild'], 'enableBasicAuth' => ['shape' => 'EnableBasicAuth'], 'basicAuthCredentials' => ['shape' => 'BasicAuthCredentials'], 'customRules' => ['shape' => 'CustomRules'], 'productionBranch' => ['shape' => 'ProductionBranch'], 'buildSpec' => ['shape' => 'BuildSpec']]], 'AppArn' => ['type' => 'string', 'max' => 1000], 'AppId' => ['type' => 'string', 'max' => 255, 'min' => 1], 'Apps' => ['type' => 'list', 'member' => ['shape' => 'App']], 'ArtifactsUrl' => ['type' => 'string', 'max' => 1000], 'BadRequestException' => ['type' => 'structure', 'members' => ['message' => ['shape' => 'ErrorMessage']], 'error' => ['httpStatusCode' => 400], 'exception' => \true], 'BasicAuthCredentials' => ['type' => 'string', 'max' => 2000], 'Branch' => ['type' => 'structure', 'required' => ['branchArn', 'branchName', 'description', 'stage', 'enableNotification', 'createTime', 'updateTime', 'environmentVariables', 'enableAutoBuild', 'customDomains', 'framework', 'activeJobId', 'totalNumberOfJobs', 'enableBasicAuth', 'ttl'], 'members' => ['branchArn' => ['shape' => 'BranchArn'], 'branchName' => ['shape' => 'BranchName'], 'description' => ['shape' => 'Description'], 'tags' => ['shape' => 'Tags'], 'stage' => ['shape' => 'Stage'], 'displayName' => ['shape' => 'DisplayName'], 'enableNotification' => ['shape' => 'EnableNotification'], 'createTime' => ['shape' => 'CreateTime'], 'updateTime' => ['shape' => 'UpdateTime'], 'environmentVariables' => ['shape' => 'EnvironmentVariables'], 'enableAutoBuild' => ['shape' => 'EnableAutoBuild'], 'customDomains' => ['shape' => 'CustomDomains'], 'framework' => ['shape' => 'Framework'], 'activeJobId' => ['shape' => 'ActiveJobId'], 'totalNumberOfJobs' => ['shape' => 'TotalNumberOfJobs'], 'enableBasicAuth' => ['shape' => 'EnableBasicAuth'], 'thumbnailUrl' => ['shape' => 'ThumbnailUrl'], 'basicAuthCredentials' => ['shape' => 'BasicAuthCredentials'], 'buildSpec' => ['shape' => 'BuildSpec'], 'ttl' => ['shape' => 'TTL']]], 'BranchArn' => ['type' => 'string', 'max' => 1000], 'BranchName' => ['type' => 'string', 'max' => 255, 'min' => 1], 'Branches' => ['type' => 'list', 'member' => ['shape' => 'Branch'], 'max' => 255], 'BuildSpec' => ['type' => 'string', 'max' => 25000, 'min' => 1], 'CertificateVerificationDNSRecord' => ['type' => 'string', 'max' => 1000], 'CommitId' => ['type' => 'string', 'max' => 255], 'CommitMessage' => ['type' => 'string', 'max' => 10000], 'CommitTime' => ['type' => 'timestamp'], 'Condition' => ['type' => 'string', 'max' => 2048, 'min' => 1], 'CreateAppRequest' => ['type' => 'structure', 'required' => ['name', 'repository', 'platform', 'oauthToken'], 'members' => ['name' => ['shape' => 'Name'], 'description' => ['shape' => 'Description'], 'repository' => ['shape' => 'Repository'], 'platform' => ['shape' => 'Platform'], 'iamServiceRoleArn' => ['shape' => 'ServiceRoleArn'], 'oauthToken' => ['shape' => 'OauthToken'], 'environmentVariables' => ['shape' => 'EnvironmentVariables'], 'enableBranchAutoBuild' => ['shape' => 'EnableBranchAutoBuild'], 'enableBasicAuth' => ['shape' => 'EnableBasicAuth'], 'basicAuthCredentials' => ['shape' => 'BasicAuthCredentials'], 'customRules' => ['shape' => 'CustomRules'], 'tags' => ['shape' => 'Tags'], 'buildSpec' => ['shape' => 'BuildSpec']]], 'CreateAppResult' => ['type' => 'structure', 'required' => ['app'], 'members' => ['app' => ['shape' => 'App']]], 'CreateBranchRequest' => ['type' => 'structure', 'required' => ['appId', 'branchName'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'branchName' => ['shape' => 'BranchName'], 'description' => ['shape' => 'Description'], 'stage' => ['shape' => 'Stage'], 'framework' => ['shape' => 'Framework'], 'enableNotification' => ['shape' => 'EnableNotification'], 'enableAutoBuild' => ['shape' => 'EnableAutoBuild'], 'environmentVariables' => ['shape' => 'EnvironmentVariables'], 'basicAuthCredentials' => ['shape' => 'BasicAuthCredentials'], 'enableBasicAuth' => ['shape' => 'EnableBasicAuth'], 'tags' => ['shape' => 'Tags'], 'buildSpec' => ['shape' => 'BuildSpec'], 'ttl' => ['shape' => 'TTL']]], 'CreateBranchResult' => ['type' => 'structure', 'required' => ['branch'], 'members' => ['branch' => ['shape' => 'Branch']]], 'CreateDomainAssociationRequest' => ['type' => 'structure', 'required' => ['appId', 'domainName', 'subDomainSettings'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'domainName' => ['shape' => 'DomainName'], 'enableAutoSubDomain' => ['shape' => 'EnableAutoSubDomain'], 'subDomainSettings' => ['shape' => 'SubDomainSettings']]], 'CreateDomainAssociationResult' => ['type' => 'structure', 'required' => ['domainAssociation'], 'members' => ['domainAssociation' => ['shape' => 'DomainAssociation']]], 'CreateTime' => ['type' => 'timestamp'], 'CustomDomain' => ['type' => 'string', 'max' => 255], 'CustomDomains' => ['type' => 'list', 'member' => ['shape' => 'CustomDomain'], 'max' => 255], 'CustomRule' => ['type' => 'structure', 'required' => ['source', 'target'], 'members' => ['source' => ['shape' => 'Source'], 'target' => ['shape' => 'Target'], 'status' => ['shape' => 'Status'], 'condition' => ['shape' => 'Condition']]], 'CustomRules' => ['type' => 'list', 'member' => ['shape' => 'CustomRule']], 'DNSRecord' => ['type' => 'string', 'max' => 1000], 'DefaultDomain' => ['type' => 'string', 'max' => 1000, 'min' => 1], 'DeleteAppRequest' => ['type' => 'structure', 'required' => ['appId'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId']]], 'DeleteAppResult' => ['type' => 'structure', 'required' => ['app'], 'members' => ['app' => ['shape' => 'App']]], 'DeleteBranchRequest' => ['type' => 'structure', 'required' => ['appId', 'branchName'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'branchName' => ['shape' => 'BranchName', 'location' => 'uri', 'locationName' => 'branchName']]], 'DeleteBranchResult' => ['type' => 'structure', 'required' => ['branch'], 'members' => ['branch' => ['shape' => 'Branch']]], 'DeleteDomainAssociationRequest' => ['type' => 'structure', 'required' => ['appId', 'domainName'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'domainName' => ['shape' => 'DomainName', 'location' => 'uri', 'locationName' => 'domainName']]], 'DeleteDomainAssociationResult' => ['type' => 'structure', 'required' => ['domainAssociation'], 'members' => ['domainAssociation' => ['shape' => 'DomainAssociation']]], 'DeleteJobRequest' => ['type' => 'structure', 'required' => ['appId', 'branchName', 'jobId'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'branchName' => ['shape' => 'BranchName', 'location' => 'uri', 'locationName' => 'branchName'], 'jobId' => ['shape' => 'JobId', 'location' => 'uri', 'locationName' => 'jobId']]], 'DeleteJobResult' => ['type' => 'structure', 'required' => ['jobSummary'], 'members' => ['jobSummary' => ['shape' => 'JobSummary']]], 'DependentServiceFailureException' => ['type' => 'structure', 'members' => ['message' => ['shape' => 'ErrorMessage']], 'error' => ['httpStatusCode' => 503], 'exception' => \true], 'Description' => ['type' => 'string', 'max' => 1000], 'DisplayName' => ['type' => 'string', 'max' => 255], 'DomainAssociation' => ['type' => 'structure', 'required' => ['domainAssociationArn', 'domainName', 'enableAutoSubDomain', 'domainStatus', 'statusReason', 'certificateVerificationDNSRecord', 'subDomains'], 'members' => ['domainAssociationArn' => ['shape' => 'DomainAssociationArn'], 'domainName' => ['shape' => 'DomainName'], 'enableAutoSubDomain' => ['shape' => 'EnableAutoSubDomain'], 'domainStatus' => ['shape' => 'DomainStatus'], 'statusReason' => ['shape' => 'StatusReason'], 'certificateVerificationDNSRecord' => ['shape' => 'CertificateVerificationDNSRecord'], 'subDomains' => ['shape' => 'SubDomains']]], 'DomainAssociationArn' => ['type' => 'string', 'max' => 1000], 'DomainAssociations' => ['type' => 'list', 'member' => ['shape' => 'DomainAssociation'], 'max' => 255], 'DomainName' => ['type' => 'string', 'max' => 255], 'DomainPrefix' => ['type' => 'string', 'max' => 255], 'DomainStatus' => ['type' => 'string', 'enum' => ['PENDING_VERIFICATION', 'IN_PROGRESS', 'AVAILABLE', 'PENDING_DEPLOYMENT', 'FAILED']], 'EnableAutoBuild' => ['type' => 'boolean'], 'EnableAutoSubDomain' => ['type' => 'boolean'], 'EnableBasicAuth' => ['type' => 'boolean'], 'EnableBranchAutoBuild' => ['type' => 'boolean'], 'EnableNotification' => ['type' => 'boolean'], 'EndTime' => ['type' => 'timestamp'], 'EnvKey' => ['type' => 'string', 'max' => 255], 'EnvValue' => ['type' => 'string', 'max' => 1000], 'EnvironmentVariables' => ['type' => 'map', 'key' => ['shape' => 'EnvKey'], 'value' => ['shape' => 'EnvValue']], 'ErrorMessage' => ['type' => 'string', 'max' => 255], 'Framework' => ['type' => 'string', 'max' => 255], 'GetAppRequest' => ['type' => 'structure', 'required' => ['appId'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId']]], 'GetAppResult' => ['type' => 'structure', 'required' => ['app'], 'members' => ['app' => ['shape' => 'App']]], 'GetBranchRequest' => ['type' => 'structure', 'required' => ['appId', 'branchName'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'branchName' => ['shape' => 'BranchName', 'location' => 'uri', 'locationName' => 'branchName']]], 'GetBranchResult' => ['type' => 'structure', 'required' => ['branch'], 'members' => ['branch' => ['shape' => 'Branch']]], 'GetDomainAssociationRequest' => ['type' => 'structure', 'required' => ['appId', 'domainName'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'domainName' => ['shape' => 'DomainName', 'location' => 'uri', 'locationName' => 'domainName']]], 'GetDomainAssociationResult' => ['type' => 'structure', 'required' => ['domainAssociation'], 'members' => ['domainAssociation' => ['shape' => 'DomainAssociation']]], 'GetJobRequest' => ['type' => 'structure', 'required' => ['appId', 'branchName', 'jobId'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'branchName' => ['shape' => 'BranchName', 'location' => 'uri', 'locationName' => 'branchName'], 'jobId' => ['shape' => 'JobId', 'location' => 'uri', 'locationName' => 'jobId']]], 'GetJobResult' => ['type' => 'structure', 'required' => ['job'], 'members' => ['job' => ['shape' => 'Job']]], 'InternalFailureException' => ['type' => 'structure', 'members' => ['message' => ['shape' => 'ErrorMessage']], 'error' => ['httpStatusCode' => 500], 'exception' => \true, 'fault' => \true], 'Job' => ['type' => 'structure', 'required' => ['summary', 'steps'], 'members' => ['summary' => ['shape' => 'JobSummary'], 'steps' => ['shape' => 'Steps']]], 'JobArn' => ['type' => 'string', 'max' => 1000], 'JobId' => ['type' => 'string', 'max' => 255], 'JobReason' => ['type' => 'string', 'max' => 255], 'JobStatus' => ['type' => 'string', 'enum' => ['PENDING', 'PROVISIONING', 'RUNNING', 'FAILED', 'SUCCEED', 'CANCELLING', 'CANCELLED']], 'JobSummaries' => ['type' => 'list', 'member' => ['shape' => 'JobSummary']], 'JobSummary' => ['type' => 'structure', 'required' => ['jobArn', 'jobId', 'commitId', 'commitMessage', 'commitTime', 'startTime', 'status', 'jobType'], 'members' => ['jobArn' => ['shape' => 'JobArn'], 'jobId' => ['shape' => 'JobId'], 'commitId' => ['shape' => 'CommitId'], 'commitMessage' => ['shape' => 'CommitMessage'], 'commitTime' => ['shape' => 'CommitTime'], 'startTime' => ['shape' => 'StartTime'], 'status' => ['shape' => 'JobStatus'], 'endTime' => ['shape' => 'EndTime'], 'jobType' => ['shape' => 'JobType']]], 'JobType' => ['type' => 'string', 'enum' => ['RELEASE', 'RETRY', 'WEB_HOOK'], 'max' => 10], 'LastDeployTime' => ['type' => 'timestamp'], 'LimitExceededException' => ['type' => 'structure', 'members' => ['message' => ['shape' => 'ErrorMessage']], 'error' => ['httpStatusCode' => 429], 'exception' => \true], 'ListAppsRequest' => ['type' => 'structure', 'members' => ['nextToken' => ['shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken'], 'maxResults' => ['shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults']]], 'ListAppsResult' => ['type' => 'structure', 'required' => ['apps'], 'members' => ['apps' => ['shape' => 'Apps'], 'nextToken' => ['shape' => 'NextToken']]], 'ListBranchesRequest' => ['type' => 'structure', 'required' => ['appId'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'nextToken' => ['shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken'], 'maxResults' => ['shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults']]], 'ListBranchesResult' => ['type' => 'structure', 'required' => ['branches'], 'members' => ['branches' => ['shape' => 'Branches'], 'nextToken' => ['shape' => 'NextToken']]], 'ListDomainAssociationsRequest' => ['type' => 'structure', 'required' => ['appId'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'nextToken' => ['shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken'], 'maxResults' => ['shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults']]], 'ListDomainAssociationsResult' => ['type' => 'structure', 'required' => ['domainAssociations'], 'members' => ['domainAssociations' => ['shape' => 'DomainAssociations'], 'nextToken' => ['shape' => 'NextToken']]], 'ListJobsRequest' => ['type' => 'structure', 'required' => ['appId', 'branchName'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'branchName' => ['shape' => 'BranchName', 'location' => 'uri', 'locationName' => 'branchName'], 'nextToken' => ['shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken'], 'maxResults' => ['shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults']]], 'ListJobsResult' => ['type' => 'structure', 'required' => ['jobSummaries'], 'members' => ['jobSummaries' => ['shape' => 'JobSummaries'], 'nextToken' => ['shape' => 'NextToken']]], 'LogUrl' => ['type' => 'string', 'max' => 1000], 'MaxResults' => ['type' => 'integer', 'max' => 100, 'min' => 1], 'Name' => ['type' => 'string', 'max' => 255, 'min' => 1], 'NextToken' => ['type' => 'string', 'max' => 2000], 'NotFoundException' => ['type' => 'structure', 'members' => ['message' => ['shape' => 'ErrorMessage']], 'error' => ['httpStatusCode' => 404], 'exception' => \true], 'OauthToken' => ['type' => 'string', 'max' => 100], 'Platform' => ['type' => 'string', 'enum' => ['IOS', 'ANDROID', 'WEB', 'REACT_NATIVE']], 'ProductionBranch' => ['type' => 'structure', 'members' => ['lastDeployTime' => ['shape' => 'LastDeployTime'], 'status' => ['shape' => 'Status'], 'thumbnailUrl' => ['shape' => 'ThumbnailUrl'], 'branchName' => ['shape' => 'BranchName']]], 'Repository' => ['type' => 'string', 'max' => 1000], 'Screenshots' => ['type' => 'map', 'key' => ['shape' => 'ThumbnailName'], 'value' => ['shape' => 'ThumbnailUrl']], 'ServiceRoleArn' => ['type' => 'string', 'max' => 1000, 'min' => 1], 'Source' => ['type' => 'string', 'max' => 2048, 'min' => 1], 'Stage' => ['type' => 'string', 'enum' => ['PRODUCTION', 'BETA', 'DEVELOPMENT', 'EXPERIMENTAL']], 'StartJobRequest' => ['type' => 'structure', 'required' => ['appId', 'branchName', 'jobType'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'branchName' => ['shape' => 'BranchName', 'location' => 'uri', 'locationName' => 'branchName'], 'jobId' => ['shape' => 'JobId'], 'jobType' => ['shape' => 'JobType'], 'jobReason' => ['shape' => 'JobReason'], 'commitId' => ['shape' => 'CommitId'], 'commitMessage' => ['shape' => 'CommitMessage'], 'commitTime' => ['shape' => 'CommitTime']]], 'StartJobResult' => ['type' => 'structure', 'required' => ['jobSummary'], 'members' => ['jobSummary' => ['shape' => 'JobSummary']]], 'StartTime' => ['type' => 'timestamp'], 'Status' => ['type' => 'string', 'max' => 3, 'min' => 3], 'StatusReason' => ['type' => 'string', 'max' => 1000], 'Step' => ['type' => 'structure', 'required' => ['stepName', 'startTime', 'status', 'endTime'], 'members' => ['stepName' => ['shape' => 'StepName'], 'startTime' => ['shape' => 'StartTime'], 'status' => ['shape' => 'JobStatus'], 'endTime' => ['shape' => 'EndTime'], 'logUrl' => ['shape' => 'LogUrl'], 'artifactsUrl' => ['shape' => 'ArtifactsUrl'], 'screenshots' => ['shape' => 'Screenshots']]], 'StepName' => ['type' => 'string', 'max' => 255], 'Steps' => ['type' => 'list', 'member' => ['shape' => 'Step']], 'StopJobRequest' => ['type' => 'structure', 'required' => ['appId', 'branchName', 'jobId'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'branchName' => ['shape' => 'BranchName', 'location' => 'uri', 'locationName' => 'branchName'], 'jobId' => ['shape' => 'JobId', 'location' => 'uri', 'locationName' => 'jobId']]], 'StopJobResult' => ['type' => 'structure', 'required' => ['jobSummary'], 'members' => ['jobSummary' => ['shape' => 'JobSummary']]], 'SubDomain' => ['type' => 'structure', 'required' => ['subDomainSetting', 'verified', 'dnsRecord'], 'members' => ['subDomainSetting' => ['shape' => 'SubDomainSetting'], 'verified' => ['shape' => 'Verified'], 'dnsRecord' => ['shape' => 'DNSRecord']]], 'SubDomainSetting' => ['type' => 'structure', 'required' => ['prefix', 'branchName'], 'members' => ['prefix' => ['shape' => 'DomainPrefix'], 'branchName' => ['shape' => 'BranchName']]], 'SubDomainSettings' => ['type' => 'list', 'member' => ['shape' => 'SubDomainSetting'], 'max' => 255], 'SubDomains' => ['type' => 'list', 'member' => ['shape' => 'SubDomain'], 'max' => 255], 'TTL' => ['type' => 'string'], 'TagKey' => ['type' => 'string', 'max' => 1000], 'TagValue' => ['type' => 'string', 'max' => 1000], 'Tags' => ['type' => 'map', 'key' => ['shape' => 'TagKey'], 'value' => ['shape' => 'TagValue']], 'Target' => ['type' => 'string', 'max' => 2048, 'min' => 1], 'ThumbnailName' => ['type' => 'string', 'max' => 256], 'ThumbnailUrl' => ['type' => 'string', 'max' => 2000, 'min' => 1], 'TotalNumberOfJobs' => ['type' => 'string', 'max' => 1000], 'UnauthorizedException' => ['type' => 'structure', 'members' => ['message' => ['shape' => 'ErrorMessage']], 'error' => ['httpStatusCode' => 401], 'exception' => \true], 'UpdateAppRequest' => ['type' => 'structure', 'required' => ['appId'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'name' => ['shape' => 'Name'], 'description' => ['shape' => 'Description'], 'platform' => ['shape' => 'Platform'], 'iamServiceRoleArn' => ['shape' => 'ServiceRoleArn'], 'environmentVariables' => ['shape' => 'EnvironmentVariables'], 'enableBranchAutoBuild' => ['shape' => 'EnableAutoBuild'], 'enableBasicAuth' => ['shape' => 'EnableBasicAuth'], 'basicAuthCredentials' => ['shape' => 'BasicAuthCredentials'], 'customRules' => ['shape' => 'CustomRules'], 'buildSpec' => ['shape' => 'BuildSpec']]], 'UpdateAppResult' => ['type' => 'structure', 'required' => ['app'], 'members' => ['app' => ['shape' => 'App']]], 'UpdateBranchRequest' => ['type' => 'structure', 'required' => ['appId', 'branchName'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'branchName' => ['shape' => 'BranchName', 'location' => 'uri', 'locationName' => 'branchName'], 'description' => ['shape' => 'Description'], 'framework' => ['shape' => 'Framework'], 'stage' => ['shape' => 'Stage'], 'enableNotification' => ['shape' => 'EnableNotification'], 'enableAutoBuild' => ['shape' => 'EnableAutoBuild'], 'environmentVariables' => ['shape' => 'EnvironmentVariables'], 'basicAuthCredentials' => ['shape' => 'BasicAuthCredentials'], 'enableBasicAuth' => ['shape' => 'EnableBasicAuth'], 'buildSpec' => ['shape' => 'BuildSpec'], 'ttl' => ['shape' => 'TTL']]], 'UpdateBranchResult' => ['type' => 'structure', 'required' => ['branch'], 'members' => ['branch' => ['shape' => 'Branch']]], 'UpdateDomainAssociationRequest' => ['type' => 'structure', 'required' => ['appId', 'domainName', 'subDomainSettings'], 'members' => ['appId' => ['shape' => 'AppId', 'location' => 'uri', 'locationName' => 'appId'], 'domainName' => ['shape' => 'DomainName', 'location' => 'uri', 'locationName' => 'domainName'], 'enableAutoSubDomain' => ['shape' => 'EnableAutoSubDomain'], 'subDomainSettings' => ['shape' => 'SubDomainSettings']]], 'UpdateDomainAssociationResult' => ['type' => 'structure', 'required' => ['domainAssociation'], 'members' => ['domainAssociation' => ['shape' => 'DomainAssociation']]], 'UpdateTime' => ['type' => 'timestamp'], 'Verified' => ['type' => 'boolean']]];
