<?php
add_shortcode('nasa_banner', 'nasa_sc_banners');
function nasa_sc_banners($atts, $content = null) {
    global $nasa_opt;
    
    $dfAtts = array(
        'align' => 'left',
        'valign' => 'top',
        'move_x' => '',
        'link' => '',
        'hover' => '',
        'content' => '',
        'font_style' => '',
        'banner_style' => '',
        'img' => '',
        'img_src' => '',
        'height' => '',
        'text_color' => 'light',
        'text-align' => '',
        'content-width' => '',
        'effect_text' => '',
        'data_delay' => '0ms',
        'seam_icon' => '',
        'is_ajax' => 'yes',
        'min_height' => 'auto',
        'el_class' => ''
    );
    $a = shortcode_atts($dfAtts, $atts);
    
    // Optimized speed
    if (!isset($nasa_opt['enable_optimized_speed']) || $nasa_opt['enable_optimized_speed'] == 1) {
        
        $atts['is_ajax'] = !isset($atts['is_ajax']) ? $a['is_ajax'] : $atts['is_ajax'];
        if (isset($atts['is_ajax']) && $atts['is_ajax'] == 'yes' &&
            (!isset($_REQUEST['nasa_load_ajax']) || $_REQUEST['nasa_load_ajax'] != '1')) {
            
            return nasa_shortcode_text('nasa_banner', $atts, $content);
        }

        // Load ajax
        elseif($atts['is_ajax'] == 'yes' && $_REQUEST['nasa_load_ajax'] == '1') {
            $a = shortcode_atts($dfAtts, nasa_shortcode_vars($atts));
            $content = str_replace(array('\\"', "\\'"), array('"', "'"), $content);
        }
    }
    
    $class_woo = (!isset($nasa_opt['disable_wow']) || !$nasa_opt['disable_wow']) ? '' : ' animated';
    
    $seam_icon = ($a['seam_icon'] != '') ? '<div class="seam_icon ' . $a['seam_icon'] . '"><span class="pe7-icon pe-7s-play"></span></div>' : '';

    $move_x = '';
    if ($a['move_x'] != '') {
        if ($a['align'] == 'left') {
            $move_x = ' left: ' . $a['move_x'] . ';';
        } elseif ($a['align'] == 'right') {
            $move_x = ' right: ' . $a['move_x'] . ';';
        }
    }

    $a_class = '';
    $a_class .= ($a['align'] != '') ? ' align-' . $a['align'] : '';
    $a_class .= ($a['valign'] != '') ? ' valign-' . $a['valign'] : '';

    $onclick = '';
    if ($a['link'] != '') {
        $a_class .= ' cursor-pointer';
        $onclick = ' onclick="window.location=\'' . $a['link'] . '\'"';
    }

    $src = '';
    $image = '';
    if ($a['img_src'] != '') {
        $image = wp_get_attachment_image_src($a['img_src'], 'full');
        $src = $image[0];
    }

    $a['height'] = !(int) $a['height'] ? 200 : (int) $a['height'];
    $height = 'height: ' . (int) $a['height'] . 'px;';
    $text_color = ($a['text_color'] != '') ? ' ' . $a['text_color'] : '';
    $text_align = ($a['text-align'] != '') ? ' ' . $a['text-align'] : '';
    $hover_effect = ($a['hover'] != '') ? ' hover-' . $a['hover'] : '';
    $content_width = ($a['content-width'] != '') ? 'width: ' . $a['content-width'] . ';' : '';
    $effect_text = ($a['effect_text'] != '') ? $a['effect_text'] : 'fadeIn';
    $data_delay = ($a['data_delay'] != '') ? $a['data_delay'] : '';
    $el_class = ($a['el_class'] != '') ? ' ' . $a['el_class'] : '';

    $content = trim($content) ?
        '<div class="row banner-content-warper"><div class="nasa-banner-content banner-content' . $a_class . $text_color . $text_align . '" style="' . $content_width . $move_x . '">' .
            '<div class="banner-inner wow ' . $effect_text . $class_woo . '" data-animation="' . $effect_text . '">' . 
                nasa_fixShortcode($content) .
            '</div>' .
        '</div></div>' : '';

    $banner_bg = 'background-image: url(' . esc_url($src) . ');';
    $banner_bg .= ($a['hover'] != 'carousel') ? ' background-position: center center;' : '';

    $bg_lax = '';
    if ($a['hover'] == 'lax' || $a['hover'] == 'carousel') {
        $bg_lax = ' ' . $banner_bg;
        $banner_bg = '';
    }

    $fontstyle = $a['font_style'] ? ' banner-font-' . $a['font_style'] : '';

    return $seam_icon .
        '<div class="banner nasa_banner' . $fontstyle . $hover_effect . $el_class . '" data-wow-delay="' . $data_delay . '"' . $onclick . ' style="' . $height . $bg_lax . $el_class . '">' .
            '<div class="banner-image nasa-banner-image" style="' . $banner_bg . '" data-height="' . $a['height'] . '"></div>' . $content .
        '</div>';
}

// **********************************************************************// 
// ! Register New Element: Banner 
// **********************************************************************//
add_action('init', 'nasa_register_banner');
function nasa_register_banner(){
    $banner_params = array(
        'name' => 'Banner',
        'base' => 'nasa_banner',
        'icon' => 'icon-wpb-nasatheme',
        'description' => esc_html__("Display banners", 'nasa-core'),
        'category' => 'Nasa Core',
        'as_parent' => array('except' => 'nasa_banner'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
        'params' => array(
            array(
                'type' => 'attach_image',
                "heading" => esc_html__("Banner Image", 'nasa-core'),
                "param_name" => "img_src"
            ),
            array(
                'type' => 'textfield',
                "heading" => esc_html__("Banner Height", 'nasa-core'),
                "param_name" => "height",
                "edit_field_class" => "vc_col-sm-4 vc_column",
                "value" => "",
                "heading" => esc_html__('Banner height', 'nasa-core')
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Link", 'nasa-core'),
                "edit_field_class" => "vc_col-sm-4 vc_column",
                "param_name" => "link"
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Content width (%)", 'nasa-core'),
                "edit_field_class" => "vc_col-sm-4 vc_column",
                "param_name" => "content-width",
                "value" => '',
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Horizontal alignment", 'nasa-core'),
                "param_name" => "align",
                "edit_field_class" => "vc_col-sm-6 vc_column",
                "value" => array(
                    esc_html__("Left", 'nasa-core') => "left",
                    esc_html__("Center", 'nasa-core') => "center",
                    esc_html__("Right", 'nasa-core') => "right"
                )
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Move Horizontal a distance (%)", "nasa-core"),
                "param_name" => "move_x",
                "value" => "",
                "edit_field_class" => "vc_col-sm-6 vc_column",
                "dependency" => array(
                    "element" => "align",
                    "value" => array(
                        "left",
                        "right"
                    )
                ),
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Vertical alignment", 'nasa-core'),
                "param_name" => "valign",
                "edit_field_class" => "vc_col-sm-6 vc_column",
                "value" => array(
                    esc_html__("Top", 'nasa-core') => "top",
                    esc_html__("Middle", 'nasa-core') => "middle",
                    esc_html__("Bottom", 'nasa-core') => "bottom"
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Text alignment", "nasa-core"),
                "param_name" => "text-align",
                "edit_field_class" => "vc_col-sm-6 vc_column",
                "value" => array(
                    esc_html__("Left", 'nasa-core') => "text-left",
                    esc_html__("Center", 'nasa-core') => "text-center",
                    esc_html__("Right", 'nasa-core') => "text-right"
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => "Text Color",
                "param_name" => "text_color",
                "edit_field_class" => "vc_col-sm-6 vc_column",
                "value" => array(
                    esc_html__('Black', 'nasa-core') => 'light',
                    esc_html__('White', 'nasa-core') => 'dark',
                )
            ),
            array(
                "type" => "textarea_html",
                "holder" => "div",
                "heading" => "Banner Text",
                "param_name" => "content",
                "value" => "Some promo text",
            ),
            array(
                "type" => "animation_style",
                "heading" => esc_html__("Effect banner content", 'nasa-core'),
                "param_name" => "effect_text",
                "value" => "fadeIn",
                "description" => esc_html__("Select initial loading animation for text content.", "nasa-core"),
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Effect banner hover.", 'nasa-core'),
                "param_name" => "hover",
                "value" => array(
                    esc_html__('None', 'nasa-core') => '',
                    esc_html__('Zoom', 'nasa-core') => 'zoom',
                    esc_html__('Zoom Out', 'nasa-core') => 'reduction',
                    esc_html__('Fade', 'nasa-core') => 'fade',
                    esc_html__('Carousel', 'nasa-core') => 'carousel',
                    esc_html__('Parallax Lax', 'nasa-core') => 'lax'
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__('Animation delay', 'nasa-core'),
                "param_name" => "data_delay",
                "value" => array(
                    esc_html__('None', 'nasa-core') => '',
                    esc_html__('100ms', 'nasa-core') => '100ms',
                    esc_html__('200ms', 'nasa-core') => '200ms',
                    esc_html__('300ms', 'nasa-core') => '300ms',
                    esc_html__('400ms', 'nasa-core') => '400ms',
                    esc_html__('500ms', 'nasa-core') => '500ms',
                    esc_html__('600ms', 'nasa-core') => '600ms',
                    esc_html__('700ms', 'nasa-core') => '700ms',
                    esc_html__('800ms', 'nasa-core') => '800ms',
                ),
                "description" => esc_html__("Delay time animation display text content", "nasa-core")
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Seam icon", 'nasa-core'),
                "param_name" => "seam_icon",
                "value" => array(
                    esc_html__('None', 'nasa-core') => '',
                    esc_html__('Left alignment', 'nasa-core') => 'align_left',
                    esc_html__('Right alignment', 'nasa-core') => 'align_right',
                )
            ),
            
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Optimized speed", 'nasa-core'),
                "param_name" => "is_ajax",
                "value" => array(
                    esc_html__('Yes', 'nasa-core') => 'yes',
                    esc_html__('No', 'nasa-core') => 'no'
                ),
                "std" => 'yes',
                "admin_label" => true
            ),
            
            array(
                "type" => "textfield",
                "heading" => esc_html__('Min height (px)', 'nasa-core'),
                "param_name" => "min_height",
                "std" => 'auto',
                "description" => esc_html__('Only use when Optimized speed "Yes"', 'nasa-core')
            ),
            
            array(
                "type" => "textfield",
                "heading" => esc_html__("Extra Class", 'nasa-core'),
                "param_name" => "el_class",
                "description" => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'nasa-core')
            )
        )
    );
    
    vc_map($banner_params);
}